/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.ProcessingContext;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedOptions(value={"useJavax", "useSingleton"})
public abstract class BaseProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("io.avaje.http.api.Controller", "io.swagger.v3.oas.annotations.OpenAPIDefinition");
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ProcessingContext.init(processingEnv, this.providePlatformAdapter());
    }

    protected abstract PlatformAdapter providePlatformAdapter();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        if (ProcessingContext.isOpenApiAvailable()) {
            this.readOpenApiDefinition(round);
            this.readTagDefinitions(round);
            this.readSecuritySchemes(round);
        }
        Set<? extends Element> controllers = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Controller"));
        for (Element element : controllers) {
            this.writeAdapter(element);
        }
        if (round.processingOver()) {
            this.writeOpenAPI();
        }
        return false;
    }

    private void readOpenApiDefinition(RoundEnvironment round) {
        Set<? extends Element> elements = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.OpenAPIDefinition"));
        for (Element element : elements) {
            ProcessingContext.doc().readApiDefinition(element);
        }
    }

    private void readTagDefinitions(RoundEnvironment round) {
        Set<? extends Element> elements = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.tags.Tag"));
        for (Element element : elements) {
            ProcessingContext.doc().addTagDefinition(element);
        }
        elements = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.tags.Tags"));
        for (Element element : elements) {
            ProcessingContext.doc().addTagsDefinition(element);
        }
    }

    private void readSecuritySchemes(RoundEnvironment round) {
        Set<? extends Element> elements = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.security.SecurityScheme"));
        for (Element element : elements) {
            ProcessingContext.doc().addSecurityScheme(element);
        }
        elements = round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.swagger.v3.oas.annotations.security.SecuritySchemes"));
        for (Element element : elements) {
            ProcessingContext.doc().addSecuritySchemes(element);
        }
    }

    private void writeOpenAPI() {
        ProcessingContext.doc().writeApi();
    }

    private void writeAdapter(Element controller) {
        if (controller instanceof TypeElement) {
            ControllerReader reader = new ControllerReader((TypeElement)controller);
            reader.read(true);
            try {
                this.writeControllerAdapter(reader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                ProcessingContext.logError(reader.beanType(), "Failed to write $Route class " + String.valueOf(e), new Object[0]);
            }
        }
    }

    public abstract void writeControllerAdapter(ControllerReader var1) throws IOException;
}

