/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.openapi.DocContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    public static void init(ProcessingEnvironment env, PlatformAdapter adapter, boolean generateOpenAPI) {
        Ctx oldCtx = CTX.get();
        Ctx newCTX = new Ctx(env, adapter, generateOpenAPI);
        if (oldCtx != null && newCTX.docContext == null) {
            newCTX.docContext = oldCtx.docContext;
        }
        CTX.set(newCTX);
    }

    public static void init(ProcessingEnvironment env, PlatformAdapter adapter) {
        ProcessingContext.init(env, adapter, true);
    }

    private static boolean isTypeAvailable(String canonicalName) {
        return null != ProcessingContext.typeElement(canonicalName);
    }

    public static TypeElement typeElement(String canonicalName) {
        return ProcessingContext.CTX.get().elementUtils.getTypeElement(canonicalName);
    }

    public static boolean isOpenApiAvailable() {
        return ProcessingContext.CTX.get().openApiAvailable;
    }

    public static boolean useJavax() {
        return ProcessingContext.CTX.get().useJavax;
    }

    public static boolean useComponent() {
        return ProcessingContext.CTX.get().useComponent;
    }

    public static void logError(Element e, String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static JavaFileObject createWriter(String cls, Element origin) throws IOException {
        return ProcessingContext.CTX.get().filer.createSourceFile(cls, origin);
    }

    public static FileObject createMetaInfWriter(String target) throws IOException {
        return ProcessingContext.CTX.get().filer.createResource(StandardLocation.CLASS_OUTPUT, "", target, new Element[0]);
    }

    public static String docComment(Element param) {
        return ProcessingContext.CTX.get().elementUtils.getDocComment(param);
    }

    public static DocContext doc() {
        return ProcessingContext.CTX.get().docContext;
    }

    public static TypeElement asElement(TypeMirror typeMirror) {
        return (TypeElement)ProcessingContext.CTX.get().typeUtils.asElement(typeMirror);
    }

    public static TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        return ProcessingContext.CTX.get().typeUtils.asMemberOf(declaredType, element);
    }

    public static List<ExecutableElement> superMethods(Element element, String methodName) {
        Types types = ProcessingContext.CTX.get().typeUtils;
        return types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> {
            TypeElement superClass = (TypeElement)types.asElement((TypeMirror)superType);
            for (ExecutableElement method : ElementFilter.methodsIn(ProcessingContext.CTX.get().elementUtils.getAllMembers(superClass))) {
                if (!method.getSimpleName().contentEquals(methodName)) continue;
                return method;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static PlatformAdapter platform() {
        return ProcessingContext.CTX.get().readAdapter;
    }

    public static void setPlatform(PlatformAdapter platform) {
        ProcessingContext.CTX.get().readAdapter = platform;
    }

    public static String diAnnotation() {
        return ProcessingContext.CTX.get().diAnnotation;
    }

    private static final class Ctx {
        private PlatformAdapter readAdapter;
        private final Messager messager;
        private final Filer filer;
        private final Elements elementUtils;
        private final Types typeUtils;
        private boolean openApiAvailable;
        private DocContext docContext;
        private final boolean useComponent;
        private final boolean useJavax;
        private final String diAnnotation;

        Ctx(ProcessingEnvironment env, PlatformAdapter adapter, boolean generateOpenAPI) {
            Map<String, String> options;
            String singletonOverride;
            this.readAdapter = adapter;
            this.messager = env.getMessager();
            this.filer = env.getFiler();
            this.elementUtils = env.getElementUtils();
            this.typeUtils = env.getTypeUtils();
            if (generateOpenAPI) {
                this.openApiAvailable = this.elementUtils.getTypeElement("io.swagger.v3.oas.annotations.OpenAPIDefinition") != null;
                this.docContext = new DocContext(env, this.openApiAvailable);
            }
            this.useComponent = (singletonOverride = (options = env.getOptions()).get("useSingleton")) != null ? !Boolean.parseBoolean(singletonOverride) : this.elementUtils.getTypeElement("io.avaje.inject.Component") != null;
            this.diAnnotation = this.useComponent ? "@Component" : "@Singleton";
            boolean javax = this.elementUtils.getTypeElement("javax.inject.Singleton") != null;
            boolean jakarta = this.elementUtils.getTypeElement("jakarta.inject.Singleton") != null;
            String override = env.getOptions().get("useJavax");
            this.useJavax = override != null || javax && jakarta ? Boolean.parseBoolean(override) : javax;
        }
    }
}

