/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.javadoc;

import io.avaje.http.generator.core.javadoc.Javadoc;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

class JavadocParser {
    private static final Set<String> IGNORED = new HashSet<String>(Arrays.asList("see", "since", "author", "version", "deprecated", "throws"));
    private static final int TEXT = 1;
    private static final int TAG_START = 2;
    private static final int DOCLET_START = 4;
    private static final int PARAM_NAME = 6;
    private static final int PARAM_DESC = 7;
    private static final int RETURN_DESC = 8;
    private static final int IGNORE = 9;
    private static final String DEPRECATED = "deprecated";
    private int previousState = 1;
    private StringBuilder currentParam = new StringBuilder();
    private StringBuilder currentDoclet = new StringBuilder();
    private StringBuilder currentContent;
    private int state = 1;
    private String returnDesc = "";
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private boolean deprecated;

    JavadocParser() {
    }

    Javadoc parse(String text) {
        StringBuilder mainContent;
        if (this.isEmpty(text)) {
            return Javadoc.EMPTY;
        }
        this.currentContent = mainContent = new StringBuilder();
        block9: for (char c : text.toCharArray()) {
            switch (this.state) {
                case 8: {
                    if (c == '\n') {
                        this.processReturnDesc(mainContent);
                    }
                }
                case 7: {
                    if (this.state == 7) {
                        this.processSetParam();
                    }
                }
                case 1: {
                    this.processText(c);
                    continue block9;
                }
                case 9: {
                    this.processIgnore(mainContent, c);
                    continue block9;
                }
                case 4: {
                    this.processDocletStart(c);
                    continue block9;
                }
                case 6: {
                    this.processParamName(c);
                    continue block9;
                }
                case 2: {
                    if (c != '>') continue block9;
                    this.state = 1;
                }
            }
        }
        if (this.state == 8) {
            this.returnDesc = this.currentContent.toString();
        }
        return this.splitMain(mainContent.toString().trim());
    }

    private void processSetParam() {
        this.params.put(this.currentParam.toString(), this.currentContent.toString().trim());
    }

    private void processReturnDesc(StringBuilder mainContent) {
        this.state = 1;
        this.previousState = 1;
        this.returnDesc = this.currentContent.toString();
        this.currentContent = mainContent;
    }

    private void processText(char c) {
        if (c == '{' || c == '@') {
            this.currentDoclet.delete(0, this.currentDoclet.length());
            this.state = 4;
        } else if (c == '<') {
            this.state = 2;
        } else if (c != '}' && c != '>') {
            this.currentContent.append(c);
        }
    }

    private void processIgnore(StringBuilder mainContent, char c) {
        if (c == '\n') {
            this.state = this.previousState;
            this.currentContent = mainContent;
        }
    }

    private void processParamName(char c) {
        if (c == ' ') {
            this.currentContent = new StringBuilder();
            this.state = 7;
            this.previousState = 7;
        } else {
            this.currentParam.append(c);
        }
    }

    private void processDocletStart(char c) {
        if (c == ' ' || c == '\n') {
            this.state = this.previousState;
            String docletName = this.currentDoclet.toString();
            if (IGNORED.contains(docletName)) {
                if (DEPRECATED.equals(docletName)) {
                    this.deprecated = true;
                }
                this.state = 9;
            } else {
                if (docletName.equals("param")) {
                    this.currentParam.delete(0, this.currentParam.length());
                    this.state = 6;
                }
                if (docletName.equals("return")) {
                    this.currentContent = new StringBuilder();
                    this.state = 8;
                    this.previousState = 8;
                }
            }
        } else {
            this.currentDoclet.append(c);
        }
    }

    private Javadoc splitMain(String mainText) {
        String desc = "";
        String summary = mainText;
        int pos = mainText.indexOf(46);
        if (pos > -1) {
            summary = mainText.substring(0, pos);
            desc = this.mergeLines(mainText.substring(pos + 1).trim());
        }
        return new Javadoc(summary, desc, this.params, this.returnDesc, this.deprecated);
    }

    String mergeLines(String multiline) {
        StringJoiner joiner = new StringJoiner(" ");
        for (String line : multiline.split("\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            joiner.add(line);
        }
        return joiner.toString();
    }

    private boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }
}

