/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.UType;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static void writeAnnotations(Append writer, Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            UType type = UType.parse(annotationMirror.getAnnotationType().asElement().asType());
            if (type.mainType().startsWith("io.avaje.http") || type.mainType().startsWith("io.swagger")) continue;
            String annotationName = annotationMirror.getAnnotationType().toString();
            StringBuilder sb = new StringBuilder("@").append(annotationName).append("(");
            boolean first = true;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getSimpleName()).append("=");
                AnnotationUtil.writeVal(sb, entry.getValue());
                first = false;
            }
            sb.append(")");
            String annotationString = sb.toString();
            writer.append(annotationString).eol();
        }
    }

    private static void writeVal(StringBuilder sb, AnnotationValue annotationValue) {
        Object value = annotationValue.getValue();
        if (value instanceof List) {
            sb.append("{");
            boolean first = true;
            for (AnnotationValue listValue : (List)value) {
                if (!first) {
                    sb.append(", ");
                }
                AnnotationUtil.writeVal(sb, listValue);
                first = false;
            }
            sb.append("}");
        } else if (value instanceof VariableElement) {
            VariableElement element = (VariableElement)value;
            UType type = UType.parse(element.asType());
            sb.append(type.full() + "." + element.toString());
        } else if (value instanceof AnnotationMirror) {
            AnnotationMirror mirror = (AnnotationMirror)value;
            String annotationName = mirror.getAnnotationType().toString();
            sb.append("@").append(annotationName).append("(");
            boolean first = true;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getSimpleName()).append("=");
                AnnotationUtil.writeVal(sb, entry.getValue());
                first = false;
            }
            sb.append(")");
        } else {
            sb.append(annotationValue.toString());
        }
    }
}

