/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.ClientPlatformAdapter;
import io.avaje.http.generator.client.ClientWriter;
import io.avaje.http.generator.client.ComponentMetaData;
import io.avaje.http.generator.client.ComponentReader;
import io.avaje.http.generator.client.SimpleComponentWriter;
import io.avaje.http.generator.core.ClientPrism;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.ImportPrism;
import io.avaje.http.generator.core.PlatformAdapter;
import io.avaje.http.generator.core.ProcessingContext;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"io.avaje.http.api.Client", "io.avaje.http.api.Client.Import"})
public class ClientProcessor
extends AbstractProcessor {
    private final ComponentMetaData metaData = new ComponentMetaData();
    private boolean useJsonB;
    private SimpleComponentWriter componentWriter;
    private boolean readModuleInfo;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        ProcessingContext.init(processingEnv, new ClientPlatformAdapter(), false);
        this.componentWriter = new SimpleComponentWriter(this.metaData);
        this.useJsonB = ProcessingContext.useJsonb();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        PlatformAdapter platform = ProcessingContext.platform();
        if (!(platform instanceof ClientPlatformAdapter)) {
            ProcessingContext.setPlatform(new ClientPlatformAdapter());
        }
        this.readModule();
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Client"))) {
            if (!ClientPrism.getInstanceOn(element).generate().booleanValue()) continue;
            this.writeClient(element);
        }
        for (Element element : round.getElementsAnnotatedWith(ProcessingContext.typeElement("io.avaje.http.api.Client.Import"))) {
            this.writeForImported(element);
        }
        this.writeComponent(round.processingOver());
        ProcessingContext.setPlatform(platform);
        return false;
    }

    private void readModule() {
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        new ComponentReader(this.metaData).read();
    }

    private void writeForImported(Element importedElement) {
        ImportPrism.getInstanceOn(importedElement).types().stream().map(ProcessingContext::asElement).filter(Objects::nonNull).forEach(this::writeClient);
    }

    private void writeClient(Element controller) {
        if (controller instanceof TypeElement) {
            ControllerReader reader = new ControllerReader((TypeElement)controller);
            reader.read(false);
            try {
                this.metaData.add(this.writeClientAdapter(reader));
            }
            catch (Throwable e) {
                e.printStackTrace();
                ProcessingContext.logError(reader.beanType(), "Failed to write client class " + String.valueOf(e), new Object[0]);
            }
        }
    }

    protected String writeClientAdapter(ControllerReader reader) throws IOException {
        return new ClientWriter(reader, this.useJsonB).write();
    }

    private void initialiseComponent() {
        this.metaData.initialiseFullName();
        try {
            this.componentWriter.init();
        }
        catch (IOException e) {
            ProcessingContext.logError("Error creating writer for JsonbComponent", e);
        }
    }

    private void writeComponent(boolean processingOver) {
        this.initialiseComponent();
        if (processingOver) {
            try {
                this.componentWriter.write();
            }
            catch (IOException e) {
                ProcessingContext.logError("Error writing component", e);
            }
        }
    }
}

