/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.AnnotationUtil;
import io.avaje.http.generator.client.ClientMethodWriter;
import io.avaje.http.generator.core.BaseControllerWriter;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.MethodReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ClientWriter
extends BaseControllerWriter {
    private static final String HTTP_CLIENT = "io.avaje.http.client.HttpClient";
    private static final String AT_GENERATED = "@Generated(\"avaje-http-client-generator\")";
    private static final String SUFFIX = "HttpClient";
    private final List<ClientMethodWriter> methodList = new ArrayList<ClientMethodWriter>();
    private final boolean useJsonb;

    ClientWriter(ControllerReader reader, boolean useJsonB) throws IOException {
        super(reader, SUFFIX);
        reader.addImportType(HTTP_CLIENT);
        this.useJsonb = useJsonB;
        this.readMethods();
        if (useJsonB) {
            reader.addImportType("io.avaje.jsonb.Types");
        }
    }

    @Override
    protected String initPackageName(String originName) {
        return super.initPackageName(originName) + ".httpclient";
    }

    private void readMethods() {
        for (MethodReader method : this.reader.methods()) {
            if (!method.isWebMethod()) continue;
            ClientMethodWriter methodWriter = new ClientMethodWriter(method, this.writer, this.useJsonb);
            methodWriter.addImportTypes(this.reader);
            this.methodList.add(methodWriter);
        }
    }

    String write() {
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeMethods();
        this.writeClassEnd();
        return this.fullName;
    }

    private void writeMethods() {
        for (ClientMethodWriter methodWriter : this.methodList) {
            methodWriter.write();
        }
    }

    private void writeClassStart() {
        this.writer.append(AT_GENERATED).eol();
        AnnotationUtil.writeAnnotations(this.writer, this.reader.beanType());
        this.writer.append("public class %s%s implements %s {", this.shortName, SUFFIX, this.shortName).eol().eol();
        this.writer.append("  private final HttpClient client;").eol().eol();
        this.writer.append("  public %s%s(HttpClient client) {", this.shortName, SUFFIX).eol();
        this.writer.append("    this.client = client;").eol();
        this.writer.append("  }").eol().eol();
    }
}

