/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.TopPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

final class ComponentMetaData {
    private final List<String> generatedClients = new ArrayList<String>();
    private String fullName;

    ComponentMetaData() {
    }

    public String toString() {
        return this.generatedClients.toString();
    }

    void initialiseFullName() {
        this.fullName();
    }

    boolean contains(String type) {
        return this.generatedClients.contains(type);
    }

    void add(String type) {
        this.generatedClients.add(type);
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    String fullName() {
        if (this.fullName == null) {
            Object topPackage = TopPackage.of(this.generatedClients);
            if (!((String)topPackage).endsWith(".httpclient")) {
                topPackage = (String)topPackage + ".httpclient";
            }
            this.fullName = (String)topPackage + ".GeneratedHttpComponent";
        }
        return this.fullName;
    }

    String packageName() {
        return TopPackage.packageOf(this.fullName());
    }

    List<String> all() {
        return this.generatedClients;
    }

    Collection<String> allImports() {
        TreeSet<String> packageImports = new TreeSet<String>(this.generatedClients);
        this.generatedClients.stream().map(s -> ComponentMetaData.removeLast(ComponentMetaData.removeLast(s, ".httpclient"), "HttpClient")).forEach(packageImports::add);
        return packageImports;
    }

    public static String removeLast(String className, String search) {
        int pos = className.lastIndexOf(search);
        if (pos > -1) {
            return className.substring(0, pos) + className.substring(pos + search.length());
        }
        return className;
    }
}

