/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.ComponentMetaData;
import io.avaje.http.generator.client.MetaDataPrism;
import io.avaje.http.generator.core.ProcessingContext;
import java.io.FileNotFoundException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ComponentReader {
    private final ComponentMetaData componentMetaData;

    ComponentReader(ComponentMetaData metaData) {
        this.componentMetaData = metaData;
    }

    void read() {
        TypeElement moduleType;
        String componentFullName = this.loadMetaInfServices();
        if (componentFullName != null && (moduleType = ProcessingContext.typeElement(componentFullName)) != null) {
            this.componentMetaData.setFullName(componentFullName);
            this.readMetaData(moduleType);
        }
    }

    private void readMetaData(TypeElement moduleType) {
        for (AnnotationMirror annotationMirror : moduleType.getAnnotationMirrors()) {
            MetaDataPrism.getOptional(annotationMirror).map(MetaDataPrism::value).stream().flatMap(Collection::stream).map(TypeMirror::toString).forEach(this.componentMetaData::add);
        }
    }

    private String loadMetaInfServices() {
        List<String> lines = this.loadMetaInf();
        return lines.isEmpty() ? null : lines.get(0);
    }

    private List<String> loadMetaInf() {
        try {
            FileObject fileObject = ProcessingContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.avaje.http.client.HttpClient$GeneratedComponent");
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            ProcessingContext.logDebug("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            ProcessingContext.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }
}

