/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.client;

import io.avaje.http.generator.client.ComponentMetaData;
import io.avaje.http.generator.client.TopPackage;
import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

final class SimpleComponentWriter {
    private static final String AT_GENERATED = "@Generated(\"avaje-client-generator\")";
    private final ComponentMetaData metaData;
    private final Set<String> importTypes = new TreeSet<String>();
    private Append writer;
    private JavaFileObject fileObject;
    private String fullName;

    SimpleComponentWriter(ComponentMetaData metaData) {
        this.metaData = metaData;
    }

    void init() throws IOException {
        if (this.fullName == null) {
            this.fullName = this.metaData.fullName();
        }
        if (this.fileObject == null) {
            this.fileObject = ProcessingContext.createWriter(this.metaData.fullName());
        }
    }

    void write() throws IOException {
        this.writer = new Append(this.fileObject.openWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeRegister();
        this.writeClassEnd();
        this.writer.close();
        this.writeMetaInf();
    }

    void writeMetaInf() throws IOException {
        FileObject fileObject = ProcessingContext.createMetaInfWriter("META-INF/services/io.avaje.http.client.HttpClient$GeneratedComponent");
        if (fileObject != null) {
            try (Writer fileWriter = fileObject.openWriter();){
                fileWriter.write(this.fullName);
            }
        }
    }

    private void writeRegister() {
        this.writer.append("  @Override").eol();
        this.writer.append("  public void register(Map<Class<?>, HttpApiProvider<?>> providerMap) {").eol();
        for (String clientFullName : this.metaData.all()) {
            String clientShortName = Util.shortName(clientFullName);
            String clientInterface = ComponentMetaData.removeLast(clientShortName, "HttpClient");
            this.writer.append("    providerMap.put(%s.class, %s::new);", clientInterface, clientShortName).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        String shortName = Util.shortName(this.fullName);
        this.writer.append(AT_GENERATED).eol();
        this.writer.append("@MetaData({");
        List<String> all = this.metaData.all();
        this.writeMetaDataEntry(all);
        this.writer.append("})").eol();
        this.writer.append("public class %s implements HttpClient.GeneratedComponent {", shortName).eol().eol();
    }

    private void writeMetaDataEntry(List<String> entries) {
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            this.writer.append("%s.class", Util.shortName(entries.get(i)));
        }
    }

    private void writeImports() {
        this.importTypes.add("io.avaje.http.client.HttpClient");
        this.importTypes.add("io.avaje.http.client.HttpApiProvider");
        this.importTypes.add("java.util.Map");
        this.importTypes.add("io.avaje.http.api.Generated");
        this.importTypes.add("io.avaje.http.api.spi.MetaData");
        this.importTypes.addAll(this.metaData.allImports());
        for (String importType : this.importTypes) {
            this.writer.append("import %s;", importType).eol();
            this.writer.append("import %s;", importType).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        String packageName = TopPackage.packageOf(this.fullName);
        if (!packageName.isEmpty()) {
            this.writer.append("package %s;", packageName).eol().eol();
        }
    }
}

