/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.ElementReader;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class MethodParam {
    private final ElementReader elementParam;

    MethodParam(VariableElement param, UType type, String rawType, ParamType defaultParamType, boolean formMarker) {
        this.elementParam = new ElementReader(param, type, rawType, defaultParamType, formMarker);
    }

    public void writeCtxGet(Append writer, PathSegments segments) {
        this.elementParam.writeCtxGet(writer, segments);
    }

    public void addImports(ControllerReader bean) {
        this.elementParam.addImports(bean);
    }

    public void writeValidate(Append writer) {
        this.elementParam.writeValidate(writer);
    }

    public void buildParamName(Append writer) {
        this.elementParam.writeParamName(writer);
    }

    public void buildApiDocumentation(MethodDocBuilder methodDoc) {
        if (this.elementParam.paramType() != ParamType.BEANPARAM) {
            this.elementParam.buildApiDocumentation(methodDoc);
        } else {
            ProcessingContext.asElement(this.elementParam.element().asType()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).map(VariableElement.class::cast).forEach(e -> MethodParam.buildDoc(methodDoc, e));
        }
    }

    private static void buildDoc(MethodDocBuilder methodDoc, VariableElement e) {
        TypeMirror typeMirror = e.asType();
        new ElementReader(e, Util.parse(typeMirror.toString()), Util.typeDef(typeMirror), ParamType.QUERYPARAM, false).buildApiDocumentation(methodDoc);
    }

    public boolean isBody() {
        return this.elementParam.paramType() == ParamType.BODY;
    }

    public boolean isForm() {
        return this.elementParam.paramType() == ParamType.FORM;
    }

    public String shortType() {
        return this.elementParam.shortType();
    }

    public String rawType() {
        return this.elementParam.rawType();
    }

    public String name() {
        return this.elementParam.varName();
    }

    public String paramName() {
        return this.elementParam.paramName();
    }

    public ParamType paramType() {
        return this.elementParam.paramType();
    }

    public UType utype() {
        return this.elementParam.type();
    }

    public void setResponseHandler() {
        this.elementParam.setResponseHandler();
    }
}

