/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.ConsumesPrism;
import io.avaje.http.generator.core.ControllerReader;
import io.avaje.http.generator.core.DeletePrism;
import io.avaje.http.generator.core.FormPrism;
import io.avaje.http.generator.core.GetPrism;
import io.avaje.http.generator.core.HttpMethodPrism;
import io.avaje.http.generator.core.InstrumentServerContextPrism;
import io.avaje.http.generator.core.JakartaValidPrism;
import io.avaje.http.generator.core.JavaxValidPrism;
import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.OpenAPIResponsePrism;
import io.avaje.http.generator.core.OpenAPIResponsesPrism;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.PatchPrism;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.PostPrism;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.ProducesPrism;
import io.avaje.http.generator.core.PutPrism;
import io.avaje.http.generator.core.RequestTimeoutPrism;
import io.avaje.http.generator.core.SecurityRequirementPrism;
import io.avaje.http.generator.core.SecurityRequirementsPrism;
import io.avaje.http.generator.core.TagPrism;
import io.avaje.http.generator.core.TagsPrism;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.ValidPrism;
import io.avaje.http.generator.core.WebMethod;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class MethodReader {
    private final ControllerReader bean;
    private final ExecutableElement element;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final Javadoc javadoc;
    private final List<String> methodRoles;
    private final Optional<ProducesPrism> producesAnnotation;
    private final Optional<ConsumesPrism> consumesAnnotation;
    private final List<SecurityRequirementPrism> securityRequirements;
    private final List<OpenAPIResponsePrism> apiResponses;
    private final ExecutableType actualExecutable;
    private final List<? extends TypeMirror> actualParams;
    private final PathSegments pathSegments;
    private final boolean hasValid;
    private final List<ExecutableElement> superMethods;
    private final Optional<RequestTimeoutPrism> timeout;
    private WebMethod webMethod;
    private String webMethodPath;
    private boolean formMarker;
    private final boolean instrumentContext;
    private final boolean hasThrows;

    MethodReader(ControllerReader bean, ExecutableElement element, ExecutableType actualExecutable) {
        this.bean = bean;
        this.element = element;
        this.actualExecutable = actualExecutable;
        this.actualParams = actualExecutable == null ? null : actualExecutable.getParameterTypes();
        this.isVoid = element.getReturnType().getKind() == TypeKind.VOID;
        this.methodRoles = Util.findRoles(element);
        this.producesAnnotation = this.findAnnotation(ProducesPrism::getOptionalOn).or(() -> ProducesPrism.getOptionalOn(bean.beanType()));
        this.consumesAnnotation = this.findAnnotation(ConsumesPrism::getOptionalOn).or(() -> ConsumesPrism.getOptionalOn(bean.beanType()));
        this.initWebMethodViaAnnotation();
        this.superMethods = ProcessingContext.superMethods(element.getEnclosingElement(), element.getSimpleName().toString());
        this.superMethods.forEach(m -> this.methodRoles.addAll(Util.findRoles(m)));
        this.hasThrows = !element.getThrownTypes().isEmpty();
        this.securityRequirements = this.readSecurityRequirements();
        this.apiResponses = this.buildApiResponses();
        this.javadoc = this.buildJavadoc(element);
        this.timeout = RequestTimeoutPrism.getOptionalOn(element);
        this.timeout.ifPresent(p -> {
            bean.addStaticImportType("java.time.temporal.ChronoUnit." + p.chronoUnit());
            bean.addStaticImportType("java.time.Duration.of");
        });
        if (this.isWebMethod()) {
            this.hasValid = this.initValid();
            this.instrumentContext = this.initResolver();
            this.pathSegments = PathSegments.parse(Util.combinePath(bean.path(), this.webMethodPath));
        } else {
            this.hasValid = false;
            this.pathSegments = null;
            this.instrumentContext = false;
        }
    }

    private boolean initResolver() {
        return this.bean.hasInstrument() || this.hasInstrument(this.element) || this.superMethods.stream().anyMatch(this::hasInstrument);
    }

    private boolean hasInstrument(Element e) {
        if (InstrumentServerContextPrism.getOptionalOn(e).isPresent()) {
            return true;
        }
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!HttpMethodPrism.isPresent(annotationMirror.getAnnotationType().asElement())) continue;
            return annotationMirror.getElementValues().values().stream().anyMatch(v -> v.getValue().equals(true));
        }
        return false;
    }

    private Javadoc buildJavadoc(ExecutableElement element) {
        return Optional.of(Javadoc.parse(ProcessingContext.docComment(element))).filter(Predicate.not(Javadoc::isEmpty)).orElseGet(() -> this.superMethods.stream().map(e -> Javadoc.parse(ProcessingContext.docComment(e))).filter(Predicate.not(Javadoc::isEmpty)).findFirst().orElse(Javadoc.parse("")));
    }

    private boolean initValid() {
        return this.findAnnotation(ValidPrism::getOptionalOn).isPresent() || this.findAnnotation(JavaxValidPrism::getOptionalOn).isPresent() || this.findAnnotation(JakartaValidPrism::getOptionalOn).isPresent() || this.superMethodHasValid();
    }

    private boolean superMethodHasValid() {
        return this.superMethods.stream().anyMatch(e -> this.findAnnotation(ValidPrism::getOptionalOn).isPresent() || this.findAnnotation(JavaxValidPrism::getOptionalOn).isPresent());
    }

    public String toString() {
        return this.element.toString();
    }

    private void initWebMethodViaAnnotation() {
        if (this.findAnnotation(FormPrism::getOptionalOn).isPresent()) {
            this.formMarker = true;
        }
        this.findAnnotation(GetPrism::getOptionalOn).ifPresent(get -> this.initSetWebMethod(WebMethod.GET, get.value()));
        this.findAnnotation(PutPrism::getOptionalOn).ifPresent(put -> this.initSetWebMethod(WebMethod.PUT, put.value()));
        this.findAnnotation(PostPrism::getOptionalOn).ifPresent(post -> this.initSetWebMethod(WebMethod.POST, post.value()));
        this.findAnnotation(PatchPrism::getOptionalOn).ifPresent(patch -> this.initSetWebMethod(WebMethod.PATCH, patch.value()));
        this.findAnnotation(DeletePrism::getOptionalOn).ifPresent(delete -> this.initSetWebMethod(WebMethod.DELETE, delete.value()));
    }

    private void initSetWebMethod(WebMethod webMethod, String value) {
        this.webMethod = webMethod;
        this.webMethodPath = value;
    }

    public Javadoc javadoc() {
        return this.javadoc;
    }

    private List<SecurityRequirementPrism> readSecurityRequirements() {
        ArrayList<SecurityRequirementPrism> list = new ArrayList<SecurityRequirementPrism>();
        this.readSecurityRequirements(this.element, list);
        for (ExecutableElement superMethod : this.superMethods) {
            this.readSecurityRequirements(superMethod, list);
        }
        this.readSecurityRequirements(this.bean.beanType(), list);
        HashMap<String, SecurityRequirementPrism> map = new HashMap<String, SecurityRequirementPrism>();
        for (SecurityRequirementPrism p : list) {
            if (map.containsKey(p.name())) continue;
            map.put(p.name(), p);
        }
        return List.copyOf(map.values());
    }

    private void readSecurityRequirements(Element element, List<SecurityRequirementPrism> list) {
        Consumer<Element> f = e -> {
            Optional.ofNullable(SecurityRequirementsPrism.getInstanceOn(e)).map(SecurityRequirementsPrism::value).ifPresent(list::addAll);
            Optional.ofNullable(SecurityRequirementPrism.getAllInstancesOn(e)).ifPresent(list::addAll);
        };
        f.accept(element);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            f.accept(annotationMirror.getAnnotationType().asElement());
        }
    }

    private List<OpenAPIResponsePrism> buildApiResponses() {
        Stream container = this.findAnnotation(OpenAPIResponsesPrism::getOptionalOn).stream().map(OpenAPIResponsesPrism::value).flatMap(Collection::stream);
        Stream methodResponses = Stream.concat(container, OpenAPIResponsePrism.getAllInstancesOn(this.element).stream());
        Stream superMethodResponses = this.superMethods.stream().flatMap(method -> Stream.concat(this.findAnnotation(OpenAPIResponsesPrism::getOptionalOn, (ExecutableElement)method).stream().map(OpenAPIResponsesPrism::value).flatMap(Collection::stream), OpenAPIResponsePrism.getAllInstancesOn(method).stream()));
        List<OpenAPIResponsePrism> responses = Stream.concat(methodResponses, superMethodResponses).collect(Collectors.toList());
        responses.addAll(this.bean.openApiResponses());
        return responses;
    }

    public <A> Optional<A> findAnnotation(Function<Element, Optional<A>> prismFunc) {
        return this.findAnnotation(prismFunc, this.element);
    }

    public <A> Optional<A> findAnnotation(Function<Element, Optional<A>> prismFunc, ExecutableElement elem) {
        return prismFunc.apply(elem).or(() -> this.bean.findMethodAnnotation(prismFunc, elem));
    }

    private List<String> addTagsToList(Element element, List<String> list) {
        if (element == null) {
            return list;
        }
        TagPrism.getAllInstancesOn(element).forEach(t -> list.add(t.name()));
        TagsPrism tags = TagsPrism.getInstanceOn(element);
        if (tags != null) {
            for (TagPrism tag : tags.value()) {
                list.add(tag.name());
            }
        }
        return list;
    }

    public List<String> tags() {
        List<String> tags = this.addTagsToList(this.element, new ArrayList<String>());
        this.superMethods.forEach(method -> this.addTagsToList((Element)method, tags));
        return this.addTagsToList(this.element.getEnclosingElement(), tags);
    }

    void read() {
        if (!this.methodRoles.isEmpty()) {
            ProcessingContext.platform().methodRoles(this.methodRoles, this.bean);
        }
        ParamType defaultParamType = this.formMarker ? ParamType.FORMPARAM : ParamType.QUERYPARAM;
        List<? extends VariableElement> parameters = this.element.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement p = parameters.get(i);
            TypeMirror typeMirror = this.actualParams != null ? this.actualParams.get(i) : p.asType();
            String rawType = Util.typeDef(typeMirror);
            UType type = Util.parse(typeMirror.toString());
            MethodParam param = new MethodParam(p, type, rawType, defaultParamType, this.formMarker);
            this.params.add(param);
            param.addImports(this.bean);
        }
    }

    public void buildApiDoc() {
        this.buildApiDocumentation();
    }

    public void buildApiDocumentation() {
        new MethodDocBuilder(this, ProcessingContext.doc()).build();
    }

    public List<String> roles() {
        ArrayList<String> roles = new ArrayList<String>(this.methodRoles);
        roles.addAll(this.bean.roles());
        return roles;
    }

    public boolean isWebMethod() {
        return this.webMethod != null;
    }

    public WebMethod webMethod() {
        return this.webMethod;
    }

    public String webMethodPath() {
        return this.webMethodPath;
    }

    public List<MethodParam> params() {
        return this.params;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public boolean hasProducesStatus() {
        return this.producesAnnotation.map(ProducesPrism::defaultStatus).filter(s -> s > 0).isPresent();
    }

    public String produces() {
        return this.producesAnnotation.map(ProducesPrism::value).orElseGet(this.bean::produces);
    }

    public Optional<ConsumesPrism> consumesAnnotation() {
        return this.consumesAnnotation;
    }

    public List<SecurityRequirementPrism> securityRequirements() {
        return this.securityRequirements;
    }

    public List<OpenAPIResponsePrism> apiResponses() {
        return this.apiResponses;
    }

    public TypeMirror returnType() {
        if (this.actualExecutable != null) {
            return this.actualExecutable.getReturnType();
        }
        return this.element.getReturnType();
    }

    public String statusCode() {
        return this.producesAnnotation.map(ProducesPrism::defaultStatus).filter(s -> s > 0).orElseGet(() -> this.webMethod.statusCode(this.isVoid)).toString();
    }

    public PathSegments pathSegments() {
        return this.pathSegments;
    }

    public String fullPath() {
        return this.pathSegments.fullPath();
    }

    public boolean includeValidate() {
        return this.bean.hasValid() || this.hasValid;
    }

    boolean hasValid() {
        return this.hasValid;
    }

    public String simpleName() {
        return this.element.getSimpleName().toString();
    }

    public boolean isFormBody() {
        for (MethodParam param : this.params) {
            if (!param.isForm()) continue;
            return true;
        }
        return false;
    }

    public String bodyType() {
        for (MethodParam param : this.params) {
            if (!param.isBody()) continue;
            return param.shortType();
        }
        return null;
    }

    public String bodyName() {
        for (MethodParam param : this.params) {
            if (!param.isBody()) continue;
            return param.name();
        }
        return "body";
    }

    public Optional<RequestTimeoutPrism> timeout() {
        return this.timeout;
    }

    public boolean instrumentContext() {
        return this.instrumentContext;
    }

    public void writeContext(Append writer, String reqName, String resName) {
        if (this.isVoid) {
            writer.append("resolver.runWith");
        } else if (this.hasThrows) {
            writer.append("resolver.callWith");
        } else {
            writer.append("resolver.supplyWith");
        }
        writer.append("(new ServerContext(%s, %s), () -> ", reqName, resName);
    }

    public ExecutableElement element() {
        return this.element;
    }
}

