/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class OpenAPIResponsePrism {
    private final String _responseCode;
    private final String _description;
    private final TypeMirror _type;
    public static final String PRISM_TYPE = "io.avaje.http.api.OpenAPIResponse";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static boolean isPresent(Element element) {
        return OpenAPIResponsePrism.getInstanceOn(element) != null;
    }

    public static OpenAPIResponsePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = OpenAPIResponsePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return OpenAPIResponsePrism.getInstance(mirror);
    }

    public static Optional<OpenAPIResponsePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = OpenAPIResponsePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return OpenAPIResponsePrism.getOptional(mirror);
    }

    public static List<OpenAPIResponsePrism> getAllInstancesOn(Element element) {
        return OpenAPIResponsePrism.getMirrors(element).map(OpenAPIResponsePrism::getInstance).collect(Collectors.toList());
    }

    public static OpenAPIResponsePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new OpenAPIResponsePrism(mirror);
    }

    public static Optional<OpenAPIResponsePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new OpenAPIResponsePrism(mirror));
    }

    private OpenAPIResponsePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._responseCode = this.getValue("responseCode", String.class);
        this._description = this.getValue("description", String.class);
        this._type = this.getValue("type", TypeMirror.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String responseCode() {
        return this._responseCode;
    }

    public String description() {
        return this._description;
    }

    public TypeMirror type() {
        return this._type;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = OpenAPIResponsePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    public static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue responseCode() {
            return this.values.get("responseCode");
        }

        public AnnotationValue description() {
            return this.values.get("description");
        }

        public AnnotationValue type() {
            return this.values.get("type");
        }
    }
}

