/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class JavaxEmailPrism {
    private final String _message;
    private final List<TypeMirror> _groups;
    private final List<TypeMirror> _payload;
    private final String _regexp;
    private final List<String> _flags;
    public static final String PRISM_TYPE = "javax.validation.constraints.Email";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isPresent(Element element) {
        return JavaxEmailPrism.getInstanceOn(element) != null;
    }

    static JavaxEmailPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = JavaxEmailPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return JavaxEmailPrism.getInstance(mirror);
    }

    static Optional<JavaxEmailPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = JavaxEmailPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return JavaxEmailPrism.getOptional(mirror);
    }

    static List<JavaxEmailPrism> getAllInstancesOn(Element element) {
        return JavaxEmailPrism.getMirrors(element).map(JavaxEmailPrism::getInstance).collect(Collectors.toList());
    }

    static List<JavaxEmailPrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return JavaxEmailPrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<JavaxEmailPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new JavaxEmailPrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(JavaxEmailPrism.getAllOnMetaAnnotations(e, seen), JavaxEmailPrism.getMirrors(element).map(JavaxEmailPrism::getInstance)));
    }

    static JavaxEmailPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new JavaxEmailPrism(mirror);
    }

    static Optional<JavaxEmailPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new JavaxEmailPrism(mirror));
    }

    private JavaxEmailPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._message = this.getValue("message", String.class);
        this._groups = this.getArrayValues("groups", TypeMirror.class);
        this._payload = this.getArrayValues("payload", TypeMirror.class);
        this._regexp = this.getValue("regexp", String.class);
        List<VariableElement> flagsMirrors = this.getArrayValues("flags", VariableElement.class);
        this._flags = new ArrayList<String>(flagsMirrors.size());
        for (VariableElement flagsMirror : flagsMirrors) {
            this._flags.add(flagsMirror.getSimpleName().toString());
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String message() {
        return this._message;
    }

    public List<TypeMirror> groups() {
        return this._groups;
    }

    public List<TypeMirror> payload() {
        return this._payload;
    }

    public String regexp() {
        return this._regexp;
    }

    public List<String> flags() {
        return this._flags;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = JavaxEmailPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JavaxEmailPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JavaxEmailPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue message() {
            return this.values.get("message");
        }

        AnnotationValue groups() {
            return this.values.get("groups");
        }

        AnnotationValue payload() {
            return this.values.get("payload");
        }

        AnnotationValue regexp() {
            return this.values.get("regexp");
        }

        AnnotationValue flags() {
            return this.values.get("flags");
        }
    }
}

