/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

final class OpenAPISerializer {
    private OpenAPISerializer() {
    }

    static String serialize(Object obj) throws IllegalAccessException {
        Class<?> cls = obj.getClass();
        StringBuilder sb = new StringBuilder();
        boolean firstElement = true;
        if (obj instanceof Collection) {
            sb.append("[");
            Collection collection = (Collection)obj;
            for (Object element : collection) {
                if (!firstElement) {
                    sb.append(",");
                }
                OpenAPISerializer.write(sb, element);
                firstElement = false;
            }
            sb.append("]");
        } else {
            if (obj instanceof Map) {
                sb.append("{");
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    if (!firstElement) {
                        sb.append(",");
                    }
                    sb.append("\"");
                    sb.append(entry.getKey());
                    sb.append("\" : ");
                    OpenAPISerializer.write(sb, entry.getValue());
                    firstElement = false;
                }
            } else {
                sb.append("{");
                Field[] fields = OpenAPISerializer.getAllFields(cls);
                boolean firstField = true;
                for (Field field : fields) {
                    if ("BIND_TYPE_AND_TYPES".equals(field.getName()) || "COMPONENTS_SCHEMAS_REF".equals(field.getName()) || "exampleSetFlag".equals(field.getName()) || "types".equals(field.getName()) || "specVersion".equals(field.getName())) continue;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null) continue;
                    if (!firstField) {
                        sb.append(",");
                    }
                    sb.append("\"");
                    sb.append(field.getName().replace("_enum", "enum"));
                    sb.append("\" : ");
                    OpenAPISerializer.write(sb, value);
                    firstField = false;
                }
            }
            sb.append("}");
        }
        return sb.toString();
    }

    static Field[] getAllFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.getCanonicalName().startsWith("java.")) {
            superclass = null;
        }
        if (superclass != null) {
            Field[] superFields = OpenAPISerializer.getAllFields(superclass);
            Field[] allFields = new Field[fields.length + superFields.length];
            System.arraycopy(fields, 0, allFields, 0, fields.length);
            System.arraycopy(superFields, 0, allFields, fields.length, superFields.length);
            return allFields;
        }
        return fields;
    }

    static boolean isPrimitiveWrapperType(Object value) {
        return value instanceof Boolean || value instanceof Character || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double;
    }

    static Object extractPrimitiveValue(Object object) {
        if (object instanceof Boolean) {
            return (boolean)((Boolean)object);
        }
        if (object instanceof Character) {
            return Character.valueOf(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return (byte)((Byte)object);
        }
        if (object instanceof Short) {
            return (short)((Short)object);
        }
        if (object instanceof Integer) {
            return (int)((Integer)object);
        }
        if (object instanceof Long) {
            return (long)((Long)object);
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return (double)((Double)object);
        }
        return object;
    }

    static void write(StringBuilder sb, Object value) throws IllegalAccessException {
        boolean isPrimitiveWrapper = OpenAPISerializer.isPrimitiveWrapperType(value);
        if (value.getClass().isPrimitive() || value instanceof String || isPrimitiveWrapper) {
            if (isPrimitiveWrapper) {
                sb.append(OpenAPISerializer.extractPrimitiveValue(value));
            } else {
                sb.append("\"");
                sb.append(value.toString().replace("\"", "\\\""));
                sb.append("\"");
            }
        } else if (value.getClass().isEnum()) {
            sb.append("\"");
            sb.append(value.toString().replace("\"", "\\\""));
            sb.append("\"");
        } else {
            sb.append(OpenAPISerializer.serialize(value));
        }
    }
}

