package io.avaje.inject.generator;

import javax.lang.model.element.ModuleElement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

final class PomPluginWriter {

  private static final String plugin =
      "  <!-- generated by avaje inject -->\n"
          + "      <plugin>\n"
          + "        <groupId>io.avaje</groupId>\n"
          + "        <artifactId>avaje-inject-maven-plugin</artifactId>\n"
          + "        <version>%s</version>\n"
          + "        <executions>\n"
          + "          <execution>\n"
          + "            <phase>process-sources</phase>\n"
          + "            <goals>\n"
          + "              <goal>provides</goal>\n"
          + "            </goals>\n"
          + "          </execution>\n"
          + "        </executions>\n"
          + "      </plugin>\n"
          + "    ";

  static void addPlugin2Pom() throws IOException {
    var module = APContext.getProjectModuleElement();
    // don't need mvn plugin with JPMS
    if (disabledOrUsingModulePath(module)) {
      return;
    }

    var pomPath = APContext.getBuildResource("").getParent().resolve("pom.xml");
    if (!pomPath.toFile().exists()) {
      return;
    }

    var pomContent = Files.readString(pomPath);
    // don't need mvn plugin if not using mvn compiler annotationProcessors
    if (pomContent.contains("avaje-inject-maven-plugin")
        || !pomContent.contains("<annotationProcessors>")
            && !pomContent.contains("<annotationProcessorPaths>")) {
      return;
    }
    APContext.logNote("Adding avaje-inject-maven-plugin Plugin to pom");
    var pluginsIndex = pomContent.indexOf("</plugins>");
    var builder = new StringBuilder(pomContent);
    if (pluginsIndex != -1) {
      builder.insert(
          pluginsIndex,
          String.format(plugin, PomPluginWriter.class.getPackage().getImplementationVersion()));

      Files.writeString(
          pomPath, builder.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }
  }

  private static boolean disabledOrUsingModulePath(ModuleElement module) {
    return !APContext.getOption("buildPlugin").map(Boolean::valueOf).orElse(true)
      || module != null && !module.isUnnamed();
  }
}
