/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.InjectModule;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;

class AllScopes {
    private final Map<String, Data> scopeAnnotations = new HashMap<String, Data>();
    private final ProcessingContext context;
    private final ScopeInfo defaultScope;

    AllScopes(ProcessingContext context) {
        this.context = context;
        this.defaultScope = new ScopeInfo(context);
    }

    ScopeInfo defaultScope() {
        return this.defaultScope;
    }

    ScopeInfo addScopeAnnotation(TypeElement type) {
        Data data = new Data(type, this.context, this);
        this.scopeAnnotations.put(type.getQualifiedName().toString(), data);
        return data.scopeInfo;
    }

    boolean providedByDefaultModule(String dependency) {
        return this.defaultScope.providesDependency(dependency);
    }

    void readBeans(RoundEnvironment roundEnv) {
        for (Data data : this.scopeAnnotations.values()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(data.type)) {
                data.scopeInfo.read((TypeElement)element, false);
            }
        }
    }

    void write(boolean processingOver) {
        for (Data value : this.scopeAnnotations.values()) {
            value.write(processingOver);
        }
        if (processingOver) {
            this.writeModuleCustomServicesFile();
        }
    }

    private void writeModuleCustomServicesFile() {
        if (this.scopeAnnotations.isEmpty()) {
            return;
        }
        try {
            FileObject jfo = this.context.createMetaInfModuleCustom();
            if (jfo != null) {
                Writer writer = jfo.openWriter();
                for (Data value : this.scopeAnnotations.values()) {
                    writer.write(value.moduleFullName());
                    writer.write("\n");
                }
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.context.logError("Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    void readModules(List<String> customScopeModules) {
        for (String customScopeModule : customScopeModules) {
            InjectModule injectModule;
            TypeElement module = this.context.element(customScopeModule);
            if (module == null || (injectModule = module.getAnnotation(InjectModule.class)) == null) continue;
            String customScopeType = injectModule.customScopeType();
            TypeElement scopeType = this.context.element(customScopeType);
            if (scopeType == null) {
                this.context.logError(module, "customScopeType [" + customScopeType + "] is invalid? on " + module, new Object[0]);
                continue;
            }
            ScopeInfo scopeInfo = this.addScopeAnnotation(scopeType);
            scopeInfo.readModuleMetaData(module);
        }
    }

    ScopeInfo get(String fullType) {
        Data data = this.scopeAnnotations.get(fullType);
        return data == null ? null : data.scopeInfo;
    }

    static class Data {
        final TypeElement type;
        final ScopeInfo scopeInfo;

        Data(TypeElement type, ProcessingContext context, AllScopes allScopes) {
            this.type = type;
            this.scopeInfo = new ScopeInfo(context, type, allScopes);
            this.scopeInfo.details(null, type);
        }

        void write(boolean processingOver) {
            this.scopeInfo.write(processingOver);
        }

        String moduleFullName() {
            return this.scopeInfo.moduleFullName();
        }
    }
}

