/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.Set;
import javax.lang.model.element.Element;

class FieldReader {
    private final Element element;
    private final String name;
    private final UtilType type;
    private final boolean nullable;
    private final String fieldType;
    private boolean requestParam;
    private String requestParamName;

    FieldReader(Element element) {
        this.element = element;
        this.name = Util.getNamed(element);
        this.nullable = Util.isNullable(element);
        this.type = Util.determineType(element.asType());
        this.fieldType = Util.unwrapProvider(this.type.rawType());
    }

    String getFieldName() {
        return this.element.getSimpleName().toString();
    }

    void addImports(Set<String> importTypes) {
        importTypes.add(this.fieldType);
    }

    String builderGetDependency() {
        StringBuilder sb = new StringBuilder();
        sb.append("b.").append(this.type.getMethod(this.nullable));
        sb.append(this.nm(this.fieldType)).append(".class");
        if (this.name != null) {
            sb.append(",\"").append(this.name).append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    void checkRequest(BeanRequestParams requestParams) {
        this.requestParam = requestParams.check(this.type.rawType());
        if (this.requestParam) {
            this.requestParamName = requestParams.argumentName(this.type.rawType());
        }
    }

    void writeRequestDependency(Append writer) {
        if (!this.requestParam) {
            this.requestParamName = writer.nextName(this.getFieldName().toLowerCase());
            String shortType = this.nm(this.type.rawType());
            writer.append("  @Inject").eol();
            writer.append("  %s %s;", shortType, this.requestParamName).eol().eol();
        }
    }

    void writeRequestInject(Append writer) {
        writer.append("    bean.%s = %s;", this.getFieldName(), this.requestParamName).eol();
    }

    private String nm(String raw) {
        return Util.shortName(raw);
    }
}

