/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.GenericTypeParser;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class GenericType {
    private final String raw;
    private String mainType;
    private final List<GenericType> params = new ArrayList<GenericType>();

    GenericType(String raw) {
        this.raw = raw;
    }

    GenericType() {
        this.raw = null;
    }

    static boolean isGeneric(String raw) {
        return raw.contains("<");
    }

    static GenericType parse(String raw) {
        return new GenericTypeParser(raw).parse();
    }

    static GenericType maybe(String paramType) {
        return GenericType.isGeneric(paramType) ? GenericType.parse(paramType) : null;
    }

    public String toString() {
        return this.raw != null ? this.raw : this.mainType + '<' + this.params + '>';
    }

    void addImports(Set<String> importTypes) {
        String type = this.trimExtends();
        if (this.includeInImports(type)) {
            importTypes.add(type);
        }
        for (GenericType param : this.params) {
            param.addImports(importTypes);
        }
    }

    private boolean includeInImports(String type) {
        return !type.startsWith("java.lang.") && type.contains(".");
    }

    void writeShort(Append writer) {
        String main = Util.shortName(this.trimExtends());
        writer.append(main);
        int paramCount = this.params.size();
        if (paramCount > 0) {
            writer.append("<");
            for (int i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    writer.append(",");
                }
                this.params.get(i).writeShort(writer);
            }
            writer.append(">");
        }
    }

    String shortName() {
        StringBuilder sb = new StringBuilder();
        this.shortName(sb);
        return sb.toString();
    }

    void shortName(StringBuilder sb) {
        sb.append(Util.shortName(this.trimExtends()));
        for (GenericType param : this.params) {
            param.shortName(sb);
        }
    }

    private String trimExtends() {
        if (this.mainType.startsWith("? extends ")) {
            return this.mainType.substring(10);
        }
        return this.mainType;
    }

    String getMainType() {
        return this.mainType;
    }

    List<GenericType> getParams() {
        return this.params;
    }

    void setMainType(String mainType) {
        this.mainType = mainType;
    }

    void addParam(GenericType param) {
        this.params.add(param);
    }
}

