/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.AnnotationUtil;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

class MethodLifecycleReader {
    private final String initMethod;
    private final String destroyMethod;
    private Element postConstructMethod;
    private Element preDestroyMethod;

    MethodLifecycleReader(TypeElement type, String initMethod, String destroyMethod) {
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
        for (Element element : type.getEnclosedElements()) {
            ElementKind kind = element.getKind();
            if (kind != ElementKind.METHOD) continue;
            this.readMethod(element);
        }
    }

    private void readMethod(Element element) {
        if (AnnotationUtil.hasAnnotationWithName(element, "PostConstruct")) {
            this.postConstructMethod = element;
        }
        if (AnnotationUtil.hasAnnotationWithName(element, "PreDestroy")) {
            this.preDestroyMethod = element;
        }
    }

    String initMethod() {
        return this.deriveFromBoth(this.initMethod, this.postConstructMethod);
    }

    String destroyMethod() {
        return this.deriveFromBoth(this.destroyMethod, this.preDestroyMethod);
    }

    private String deriveFromBoth(String base, Element method) {
        return this.isEmpty(base) ? this.fromMethod(method) : base;
    }

    private String fromMethod(Element method) {
        return method == null ? null : method.getSimpleName().toString();
    }

    private boolean isEmpty(String val) {
        return val == null || val.isEmpty();
    }
}

