/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Bean;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodLifecycleReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class MethodReader {
    private static final String CODE_COMMENT_BUILD_FACTORYBEAN = "  /**\n   * Create and register %s via factory bean method %s#%s().\n   */";
    private final ExecutableElement element;
    private final String factoryType;
    private final String methodName;
    private final String returnTypeRaw;
    private final String shortName;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final String factoryShortName;
    private final boolean isFactory;
    private final String initMethod;
    private final String destroyMethod;
    private final String name;
    private final TypeReader typeReader;
    private final boolean optionalType;

    MethodReader(ProcessingContext context, ExecutableElement element, TypeElement beanType) {
        this(context, element, beanType, null, null);
    }

    MethodReader(ProcessingContext context, ExecutableElement element, TypeElement beanType, Bean bean, Named named) {
        this.isFactory = bean != null;
        this.element = element;
        this.methodName = element.getSimpleName().toString();
        TypeMirror returnMirror = element.getReturnType();
        String raw = returnMirror.toString();
        if (Util.isOptional(raw)) {
            this.optionalType = true;
            this.returnTypeRaw = Util.extractOptionalType(raw);
        } else {
            this.optionalType = false;
            this.returnTypeRaw = raw;
        }
        this.shortName = Util.shortName(this.returnTypeRaw);
        this.factoryType = beanType.getQualifiedName().toString();
        this.factoryShortName = Util.shortName(this.factoryType);
        this.isVoid = Util.isVoid(this.returnTypeRaw);
        String initMethod = bean == null ? null : bean.initMethod();
        String destroyMethod = bean == null ? null : bean.destroyMethod();
        this.name = named == null ? null : named.value().toLowerCase();
        TypeElement returnElement = context.element(this.returnTypeRaw);
        if (returnElement == null) {
            this.typeReader = null;
            this.initMethod = initMethod;
            this.destroyMethod = destroyMethod;
        } else {
            this.typeReader = new TypeReader(returnElement, context);
            this.typeReader.process();
            MethodLifecycleReader lifecycleReader = new MethodLifecycleReader(returnElement, initMethod, destroyMethod);
            this.initMethod = lifecycleReader.initMethod();
            this.destroyMethod = lifecycleReader.destroyMethod();
        }
    }

    MethodReader read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
        return this;
    }

    String getName() {
        return this.methodName;
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw, this.name);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        for (MethodParam param : this.params) {
            dependsOn.add(param.paramType);
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(new ArrayList<String>());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$DI" + ".build_" + this.element.getSimpleName().toString();
    }

    String builderGetFactory() {
        return String.format("      %s factory = builder.get(%s.class);", this.factoryShortName, this.factoryShortName);
    }

    String builderBuildBean() {
        StringBuilder sb = new StringBuilder();
        sb.append("      ");
        if (this.isVoid) {
            sb.append(String.format("factory.%s(", this.methodName));
        } else {
            String beanType = this.optionalType ? String.format("Optional<%s>", this.shortName) : this.shortName;
            String beanName = this.optionalType ? "optionalBean" : "bean";
            sb.append(beanType);
            sb.append(String.format(" %s = factory.%s(", beanName, this.methodName));
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.params.get(i).builderGetDependency("builder"));
        }
        sb.append(");");
        return sb.toString();
    }

    void builderBuildAddBean(Append writer) {
        if (!this.isVoid) {
            String indent;
            String string = indent = this.optionalType ? "        " : "      ";
            if (this.optionalType) {
                writer.append("      if (optionalBean.isPresent()) {").eol();
                writer.append("        %s bean = optionalBean.get();", this.shortName).eol();
            }
            writer.append(indent);
            if (this.hasLifecycleMethods()) {
                writer.append("%s $bean = ", this.shortName);
            }
            writer.append("builder.register(bean);").eol();
            if (this.notEmpty(this.initMethod)) {
                writer.append(indent).append("builder.addPostConstruct($bean::%s);", this.initMethod).eol();
            }
            if (this.notEmpty(this.destroyMethod)) {
                writer.append(indent).append("builder.addPreDestroy($bean::%s);", this.destroyMethod).eol();
            } else if (this.typeReader.isClosable()) {
                writer.append(indent).append("builder.addPreDestroy($bean::close);", this.destroyMethod).eol();
            }
            if (this.optionalType) {
                writer.append("      }").eol();
            }
        }
    }

    private boolean hasLifecycleMethods() {
        return this.notEmpty(this.initMethod) || this.notEmpty(this.destroyMethod) || this.typeReader.isClosable();
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    void addImports(Set<String> importTypes) {
        for (MethodParam param : this.params) {
            param.addImports(importTypes);
        }
        if (this.isFactory) {
            importTypes.add(this.returnTypeRaw);
        }
        if (this.optionalType) {
            importTypes.add("java.util.Optional");
        }
        if (this.typeReader != null) {
            this.typeReader.addImports(importTypes);
        }
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.isVoid) {
            writer.append("Void.class");
        } else {
            if (this.name != null && !this.name.isEmpty()) {
                writer.append("\"%s\", ", this.name);
            }
            if (this.typeReader != null) {
                writer.append(this.typeReader.getTypesRegister());
            }
        }
        writer.append(")) {").eol();
    }

    void checkRequest(BeanRequestParams requestParams) {
        for (MethodParam param : this.params) {
            param.checkRequest(requestParams);
        }
    }

    void writeRequestDependency(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestDependency(writer);
        }
    }

    void writeRequestConstructor(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestConstructor(writer);
        }
    }

    public void commentBuildMethod(Append writer) {
        writer.append(CODE_COMMENT_BUILD_FACTORYBEAN, this.shortName, this.factoryShortName, this.methodName).eol();
    }

    public boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isNotPrivate() {
        return !this.element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    static class MethodParam {
        private final String named;
        private final UtilType utilType;
        private final String paramType;
        private final GenericType genericType;
        private final boolean nullable;
        private int providerIndex;
        private boolean requestParam;
        private String requestParamName;

        MethodParam(VariableElement param) {
            this.named = Util.getNamed(param);
            this.nullable = Util.isNullable(param);
            this.utilType = Util.determineType(param.asType());
            this.paramType = this.utilType.rawType();
            this.genericType = GenericType.maybe(this.paramType);
        }

        String builderGetDependency(String builderName) {
            StringBuilder sb = new StringBuilder();
            if (this.isGenericParam()) {
                sb.append("prov").append(this.providerIndex).append(".get(");
            } else {
                sb.append(builderName).append(".").append(this.utilType.getMethod(this.nullable));
            }
            if (this.genericType == null) {
                sb.append(Util.shortName(this.paramType)).append(".class");
            } else if (this.isProvider()) {
                sb.append(this.providerParam()).append(".class");
            }
            if (this.named != null) {
                sb.append(",\"").append(this.named).append("\"");
            }
            sb.append(")");
            return sb.toString();
        }

        private String providerParam() {
            return Util.shortName(Util.unwrapProvider(this.paramType));
        }

        boolean isProvider() {
            return Util.isProvider(this.paramType);
        }

        boolean isGenericType() {
            return this.genericType != null;
        }

        boolean isGenericParam() {
            return this.isGenericType() && !this.isProvider();
        }

        String getDependsOn() {
            return this.paramType;
        }

        void addImports(Set<String> importTypes) {
            if (this.genericType != null) {
                importTypes.add("javax.inject.Provider");
                this.genericType.addImports(importTypes);
            } else {
                importTypes.add(this.paramType);
            }
        }

        void addProviderParam(Append writer, int providerIndex) {
            this.providerIndex = providerIndex;
            writer.append(", ");
            writer.append("Provider<");
            this.genericType.writeShort(writer);
            writer.append("> prov%s", providerIndex);
        }

        void checkRequest(BeanRequestParams requestParams) {
            this.requestParam = requestParams.check(this.paramType);
            if (this.requestParam) {
                this.requestParamName = requestParams.argumentName(this.paramType);
            }
        }

        void writeRequestDependency(Append writer) {
            if (!this.requestParam) {
                String shortType = this.nm(this.paramType);
                this.requestParamName = writer.nextName(shortType.toLowerCase());
                writer.append("  @Inject").eol();
                writer.append("  %s %s;", shortType, this.requestParamName).eol().eol();
            }
        }

        void writeRequestConstructor(Append writer) {
            writer.commaAppend(this.requestParamName);
        }

        private String nm(String raw) {
            return Util.shortName(raw);
        }
    }
}

