/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeExtendsInjection;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class TypeExtendsReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final TypeElement baseType;
    private final ProcessingContext context;
    private final List<String> extendsTypes = new ArrayList<String>();
    private final TypeExtendsInjection extendsInjection;
    private final List<String> interfaceTypes = new ArrayList<String>();
    private final String beanSimpleName;
    private boolean closeable;
    private String qualifierName;
    private String baseTypeRaw;

    TypeExtendsReader(TypeElement baseType, ProcessingContext context, boolean factory) {
        this.baseType = baseType;
        this.context = context;
        this.extendsInjection = new TypeExtendsInjection(baseType, context, factory);
        this.beanSimpleName = baseType.getSimpleName().toString();
    }

    String getBaseType() {
        return this.baseTypeRaw;
    }

    List<String> getExtendsTypes() {
        return this.extendsTypes;
    }

    String getQualifierName() {
        return this.qualifierName;
    }

    List<FieldReader> getInjectFields() {
        return this.extendsInjection.getInjectFields();
    }

    List<MethodReader> getInjectMethods() {
        return this.extendsInjection.getInjectMethods();
    }

    List<MethodReader> getFactoryMethods() {
        return this.extendsInjection.getFactoryMethods();
    }

    Element getPostConstructMethod() {
        return this.extendsInjection.getPostConstructMethod();
    }

    Element getPreDestroyMethod() {
        return this.extendsInjection.getPreDestroyMethod();
    }

    MethodReader getConstructor() {
        return this.extendsInjection.getConstructor();
    }

    List<String> getInterfaceTypes() {
        return this.interfaceTypes;
    }

    boolean isCloseable() {
        return this.closeable;
    }

    void process(boolean forBean) {
        String base = Util.unwrapProvider(this.baseType.getQualifiedName().toString());
        if (!GenericType.isGeneric(base)) {
            this.baseTypeRaw = base;
            this.extendsTypes.add(base);
            if (forBean) {
                this.extendsInjection.read(this.baseType);
            }
        }
        this.readInterfaces(this.baseType);
        TypeElement superElement = this.superOf(this.baseType);
        if (superElement != null) {
            String superName;
            String baseName;
            if (this.qualifierName == null && (baseName = this.baseType.getSimpleName().toString()).endsWith(superName = superElement.getSimpleName().toString())) {
                this.qualifierName = baseName.substring(0, baseName.length() - superName.length()).toLowerCase();
            }
            this.addSuperType(superElement);
        }
    }

    private void addSuperType(TypeElement element) {
        String type;
        this.readInterfaces(element);
        String fullName = element.getQualifiedName().toString();
        if (!fullName.equals(JAVA_LANG_OBJECT) && !GenericType.isGeneric(type = Util.unwrapProvider(fullName))) {
            this.extendsTypes.add(type);
            this.extendsInjection.read(element);
            this.addSuperType(this.superOf(element));
        }
    }

    private TypeElement superOf(TypeElement element) {
        return (TypeElement)this.context.asElement(element.getSuperclass());
    }

    private void readInterfaces(TypeElement type) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            String iShortName;
            String rawType = Util.unwrapProvider(typeMirror.toString());
            if (rawType.indexOf(46) == -1) {
                this.context.logWarn("skip when no package on interface " + rawType, new Object[0]);
                continue;
            }
            if ("java.lang.AutoCloseable".equals(rawType) || "java.io.Closeable".equals(rawType)) {
                this.closeable = true;
                continue;
            }
            if (this.qualifierName == null && this.beanSimpleName.endsWith(iShortName = Util.shortName(rawType))) {
                this.qualifierName = this.beanSimpleName.substring(0, this.beanSimpleName.length() - iShortName.length()).toLowerCase();
            }
            this.interfaceTypes.add(rawType);
            this.readExtendedInterfaces(rawType);
        }
    }

    private void readExtendedInterfaces(String type) {
        TypeElement element = this.context.element(type);
        if (element != null) {
            this.readInterfaces(element);
        }
    }
}

