/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Primary;
import io.avaje.inject.Secondary;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

class BeanReader {
    private final ProcessingContext context;
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final String name;
    private final MethodReader constructor;
    private final List<FieldReader> injectFields;
    private final List<MethodReader> injectMethods;
    private final List<MethodReader> factoryMethods;
    private final Element postConstructMethod;
    private final Element preDestroyMethod;
    private final Set<String> importTypes = new TreeSet<String>();
    private final BeanRequestParams requestParams;
    private final TypeReader typeReader;
    private final boolean primary;
    private final boolean secondary;
    private boolean writtenToFile;

    BeanReader(TypeElement beanType, ProcessingContext context, boolean factory) {
        this.beanType = beanType;
        this.context = context;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        this.primary = beanType.getAnnotation(Primary.class) != null;
        this.secondary = !this.primary && beanType.getAnnotation(Secondary.class) != null;
        this.typeReader = new TypeReader(beanType, context, this.importTypes, factory);
        this.typeReader.process();
        this.requestParams = new BeanRequestParams(this.type);
        this.name = this.typeReader.getName();
        this.injectMethods = this.typeReader.getInjectMethods();
        this.injectFields = this.typeReader.getInjectFields();
        this.factoryMethods = this.typeReader.getFactoryMethods();
        this.postConstructMethod = this.typeReader.getPostConstructMethod();
        this.preDestroyMethod = this.typeReader.getPreDestroyMethod();
        this.constructor = this.typeReader.getConstructor();
    }

    public String toString() {
        return this.beanType.toString();
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    BeanReader read() {
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
            this.constructor.checkRequest(this.requestParams);
        }
        for (FieldReader fields : this.injectFields) {
            fields.addImports(this.importTypes);
            fields.checkRequest(this.requestParams);
        }
        for (MethodReader methods : this.injectMethods) {
            methods.addImports(this.importTypes);
            methods.checkRequest(this.requestParams);
        }
        for (MethodReader factoryMethod : this.factoryMethods) {
            factoryMethod.addImports(this.importTypes);
        }
        return this;
    }

    List<String> getDependsOn() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param : this.constructor.getParams()) {
                list.add(param.getDependsOn());
            }
        }
        return list;
    }

    List<MethodReader> getFactoryMethods() {
        return this.factoryMethods;
    }

    List<String> getInterfaces() {
        return this.typeReader.getInterfaces();
    }

    Set<GenericType> getGenericTypes() {
        return this.typeReader.getGenericTypes();
    }

    private String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    String getMetaKey() {
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean hasLifecycleMethods() {
        return this.postConstructMethod != null || this.preDestroyMethod != null || this.typeReader.isClosable();
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.type, this.name);
        metaData.update(this);
        return metaData;
    }

    boolean isExtraInjectionRequired() {
        return !this.injectFields.isEmpty() || !this.injectMethods.isEmpty();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.name != null && !this.name.isEmpty()) {
            writer.append("\"%s\", ", this.name);
        }
        writer.append(this.typeReader.getTypesRegister());
        writer.append(")) {").eol();
    }

    void buildRegister(Append writer) {
        writer.append("      ");
        if (this.isExtraInjectionRequired() || this.hasLifecycleMethods()) {
            writer.append("%s $bean = ", this.shortName);
        }
        String flags = this.primary ? "Primary" : (this.secondary ? "Secondary" : "");
        writer.append("builder.register%s(bean);", flags).eol();
    }

    void addLifecycleCallbacks(Append writer) {
        if (this.postConstructMethod != null) {
            writer.append("      builder.addPostConstruct($bean::%s);", this.postConstructMethod.getSimpleName()).eol();
        }
        if (this.preDestroyMethod != null) {
            writer.append("      builder.addPreDestroy($bean::%s);", this.preDestroyMethod.getSimpleName()).eol();
        } else if (this.typeReader.isClosable()) {
            writer.append("      builder.addPreDestroy($bean);").eol();
        }
    }

    private Set<String> importTypes() {
        this.importTypes.add("io.avaje.inject.spi.Generated");
        this.importTypes.add("io.avaje.inject.spi.Builder");
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        this.typeReader.extraImports(this.importTypes);
        this.requestParams.addImports(this.importTypes);
        return this.importTypes;
    }

    void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    MethodReader getConstructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    boolean isRequestScopedController() {
        return this.requestParams.isRequestScopedController();
    }

    String suffix() {
        return this.isRequestScopedController() ? "$Factory" : "$DI";
    }

    void factoryInterface(Append writer) {
        this.requestParams.factoryInterface(writer);
    }

    void writeRequestCreate(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeRequestDependency(writer);
        }
        for (FieldReader field : this.injectFields) {
            field.writeRequestDependency(writer);
        }
        for (MethodReader method : this.injectMethods) {
            method.writeRequestDependency(writer);
        }
        this.requestParams.writeRequestCreate(writer);
        writer.resetNextName();
        writer.append("    %s bean = new %s(", this.shortName, this.shortName);
        if (this.constructor != null) {
            this.constructor.writeRequestConstructor(writer);
        }
        writer.append(");").eol();
        for (FieldReader field : this.injectFields) {
            field.writeRequestInject(writer);
        }
        for (MethodReader method : this.injectMethods) {
            writer.append("    bean.%s(", method.getName());
            method.writeRequestConstructor(writer);
            writer.append(");").eol();
        }
        writer.append("    return bean;").eol();
        writer.append("  }").eol();
    }

    List<FieldReader> getInjectFields() {
        return this.typeReader.getInjectFields();
    }

    List<MethodReader> getInjectMethods() {
        return this.typeReader.getInjectMethods();
    }
}

