/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;

class MetaDataOrdering {
    private static final String CIRC_ERR_MSG = "To handle circular dependencies consider using field injection rather than constructor injection on one of the dependencies. \n See https://avaje.io/inject/#circular";
    private final ProcessingContext context;
    private final ScopeInfo scopeInfo;
    private final List<MetaData> orderedList = new ArrayList<MetaData>();
    private final List<MetaData> queue = new ArrayList<MetaData>();
    private final Map<String, ProviderList> providers = new HashMap<String, ProviderList>();
    private final List<DependencyLink> circularDependencies = new ArrayList<DependencyLink>();
    private final Set<String> missingDependencyTypes = new LinkedHashSet<String>();

    MetaDataOrdering(Collection<MetaData> values, ProcessingContext context, ScopeInfo scopeInfo) {
        this.context = context;
        this.scopeInfo = scopeInfo;
        for (MetaData metaData : values) {
            if (metaData.noDepends()) {
                this.orderedList.add(metaData);
                metaData.setWired();
            } else {
                this.queue.add(metaData);
            }
            this.providers.computeIfAbsent(metaData.getType(), s -> new ProviderList()).add(metaData);
            for (String provide : metaData.getProvides()) {
                this.providers.computeIfAbsent(provide, s -> new ProviderList()).add(metaData);
            }
        }
        this.externallyRequiredDependencies();
    }

    private void externallyRequiredDependencies() {
        for (String requireType : this.scopeInfo.requires()) {
            this.providers.computeIfAbsent(requireType, s -> new ProviderList());
        }
    }

    int processQueue() {
        int count;
        while ((count = this.processQueueRound()) > 0) {
        }
        int remaining = this.queue.size();
        if (remaining != 0) {
            this.missingDependencies();
            this.orderedList.addAll(this.queue);
        }
        return remaining;
    }

    private void detectCircularDependency(List<MetaData> remainder) {
        ArrayList<DependencyLink> dependencyLinks = new ArrayList<DependencyLink>();
        for (MetaData metaData : remainder) {
            List<String> dependsOn = metaData.getDependsOn();
            if (dependsOn == null) continue;
            for (String dependency : dependsOn) {
                MetaData provider = this.findCircularDependency(remainder, dependency);
                if (provider == null) continue;
                dependencyLinks.add(new DependencyLink(metaData, provider, dependency));
            }
        }
        if (dependencyLinks.size() > 1) {
            this.circularDependencies.addAll(dependencyLinks);
        }
    }

    private MetaData findCircularDependency(List<MetaData> remainder, String dependency) {
        for (MetaData metaData : remainder) {
            if (metaData.getType().equals(dependency)) {
                return metaData;
            }
            List<String> provides = metaData.getProvides();
            if (provides == null || !provides.contains(dependency)) continue;
            return metaData;
        }
        return null;
    }

    private void errorOnCircularDependencies() {
        this.context.logError("Circular dependencies detected with beans %s  %s", this.circularDependencies, CIRC_ERR_MSG);
        for (DependencyLink link : this.circularDependencies) {
            this.context.logError("Circular dependency - %s dependsOn %s for %s", link.metaData, link.provider, link.dependency);
        }
    }

    void missingDependencies() {
        for (MetaData metaData : this.queue) {
            this.checkMissingDependencies(metaData);
        }
        if (this.missingDependencyTypes.isEmpty()) {
            this.detectCircularDependency(this.queue);
        }
    }

    private void checkMissingDependencies(MetaData metaData) {
        for (String dependency : metaData.getDependsOn()) {
            if (this.providers.get(dependency) != null || this.scopeInfo.providedByOtherModule(dependency)) continue;
            TypeElement element = this.context.elementMaybe(metaData.getType());
            this.context.logError(element, "No dependency provided for " + dependency + " on " + metaData.getType(), new Object[0]);
            this.missingDependencyTypes.add(dependency);
        }
    }

    private void warnOnDependencies() {
        if (!this.missingDependencyTypes.isEmpty()) {
            this.context.logError("Dependencies %s are not provided - missing @Singleton or @Factory/@Bean or specify external dependency via @InjectModule requires attribute", this.missingDependencyTypes);
        } else if (!this.queue.isEmpty()) {
            this.context.logWarn("There are " + this.queue.size() + " beans with unsatisfied dependencies (assuming external dependencies)", new Object[0]);
            for (MetaData m : this.queue) {
                this.context.logWarn("Unsatisfied dependencies on %s dependsOn %s", m, m.getDependsOn());
            }
        }
    }

    void logWarnings() {
        if (this.hasCircularDependencies()) {
            this.errorOnCircularDependencies();
        } else {
            this.warnOnDependencies();
        }
    }

    private int processQueueRound() {
        int count = 0;
        Iterator<MetaData> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            MetaData queuedMeta = iterator.next();
            if (!this.allDependenciesWired(queuedMeta)) continue;
            this.orderedList.add(queuedMeta);
            queuedMeta.setWired();
            iterator.remove();
            ++count;
        }
        return count;
    }

    private boolean allDependenciesWired(MetaData queuedMeta) {
        for (String dependency : queuedMeta.getDependsOn()) {
            if (Util.isProvider(dependency)) continue;
            ProviderList providerList = this.providers.get(dependency);
            if (providerList == null) {
                return this.scopeInfo.providedByOtherModule(dependency);
            }
            if (providerList.isAllWired()) continue;
            return false;
        }
        return true;
    }

    List<MetaData> getOrdered() {
        return this.orderedList;
    }

    Set<String> getImportTypes() {
        TreeSet<String> importTypes = new TreeSet<String>();
        for (MetaData metaData : this.orderedList) {
            metaData.addImportTypes(importTypes);
        }
        return importTypes;
    }

    MetaData findProviderOf(String depend) {
        for (MetaData metaData : this.orderedList) {
            List<String> provides = metaData.getProvides();
            if (provides == null) continue;
            for (String provide : provides) {
                if (!provide.equals(depend)) continue;
                return metaData;
            }
        }
        return null;
    }

    private boolean hasCircularDependencies() {
        return !this.circularDependencies.isEmpty();
    }

    private static class ProviderList {
        private final List<MetaData> list = new ArrayList<MetaData>();

        private ProviderList() {
        }

        void add(MetaData beanMeta) {
            this.list.add(beanMeta);
        }

        boolean isAllWired() {
            for (MetaData metaData : this.list) {
                if (metaData.isWired()) continue;
                return false;
            }
            return true;
        }
    }

    private static class DependencyLink {
        final MetaData metaData;
        final MetaData provider;
        final String dependency;

        DependencyLink(MetaData metaData, MetaData provider, String dependency) {
            this.metaData = metaData;
            this.provider = provider;
            this.dependency = dependency;
        }

        public String toString() {
            return this.metaData.toString();
        }
    }
}

