/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Factory;
import io.avaje.inject.InjectModule;
import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class Processor
extends AbstractProcessor {
    private ProcessingContext context;
    private Elements elementUtils;
    private ScopeInfo defaultScope;
    private AllScopes allScopes;
    private boolean readModuleInfo;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.context = new ProcessingContext(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.allScopes = new AllScopes(this.context);
        this.defaultScope = this.allScopes.defaultScope();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(InjectModule.class.getCanonicalName());
        annotations.add(Factory.class.getCanonicalName());
        annotations.add(Singleton.class.getCanonicalName());
        annotations.add(Scope.class.getCanonicalName());
        annotations.add("io.avaje.http.api.Controller");
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<Object> controllers = Collections.emptySet();
        TypeElement typeElement = this.elementUtils.getTypeElement("io.avaje.http.api.Controller");
        if (typeElement != null) {
            controllers = roundEnv.getElementsAnnotatedWith(typeElement);
        }
        Set<? extends Element> factoryBeans = roundEnv.getElementsAnnotatedWith(Factory.class);
        Set<? extends Element> beans = roundEnv.getElementsAnnotatedWith(Singleton.class);
        Set<? extends Element> scopes = roundEnv.getElementsAnnotatedWith(Scope.class);
        this.readScopes(scopes);
        this.readModule(roundEnv);
        this.readChangedBeans(factoryBeans, true);
        this.readChangedBeans(beans, false);
        this.readChangedBeans(controllers, false);
        this.allScopes.readBeans(roundEnv);
        this.defaultScope.write(roundEnv.processingOver());
        this.allScopes.write(roundEnv.processingOver());
        return false;
    }

    private void readScopes(Set<? extends Element> scopes) {
        for (Element element : scopes) {
            if (element.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            TypeElement type = (TypeElement)element;
            this.allScopes.addScopeAnnotation(type);
        }
    }

    private void readChangedBeans(Set<? extends Element> beans, boolean factory) {
        for (Element element : beans) {
            if (!(element instanceof TypeElement)) {
                this.context.logError("unexpected type [" + element + "]", new Object[0]);
                continue;
            }
            TypeElement typeElement = (TypeElement)element;
            if (!factory) {
                this.defaultScope.read(typeElement, factory);
                continue;
            }
            ScopeInfo scope = this.findScope(typeElement);
            if (scope != null) {
                scope.read(typeElement, true);
                continue;
            }
            this.defaultScope.read(typeElement, true);
        }
    }

    private ScopeInfo findScope(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ScopeInfo scopeInfo = this.allScopes.get(annotationMirror.getAnnotationType().toString());
            if (scopeInfo == null) continue;
            return scopeInfo;
        }
        return null;
    }

    private void readModule(RoundEnvironment roundEnv) {
        TypeElement moduleType;
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        String factory = this.context.loadMetaInfServices();
        if (factory != null && (moduleType = this.elementUtils.getTypeElement(factory)) != null) {
            this.defaultScope.readModuleMetaData(moduleType);
        }
        this.allScopes.readModules(this.context.loadMetaInfCustom());
        this.readInjectModule(roundEnv);
    }

    private void readInjectModule(RoundEnvironment roundEnv) {
        InjectModule annotation;
        Element element;
        Scope scope;
        Iterator<? extends Element> iterator;
        Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(InjectModule.class);
        if (!elementsAnnotatedWith.isEmpty() && (iterator = elementsAnnotatedWith.iterator()).hasNext() && (scope = (element = iterator.next()).getAnnotation(Scope.class)) == null && (annotation = element.getAnnotation(InjectModule.class)) != null) {
            this.defaultScope.details(annotation.name(), element);
        }
    }
}

