/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class RequestScope {
    private static final String JEX_CONTEXT = "io.avaje.jex.Context";
    private static final String JAVALIN_CONTEXT = "io.javalin.http.Context";
    private static final String HELIDON_REQ = "io.helidon.webserver.ServerRequest";
    private static final String HELIDON_RES = "io.helidon.webserver.ServerResponse";
    private static final Map<String, Handler> TYPES = new HashMap<String, Handler>();

    RequestScope() {
    }

    static boolean check(String type) {
        return TYPES.containsKey(type);
    }

    static Handler handler(String type) {
        return TYPES.get(type);
    }

    static {
        TYPES.put(JEX_CONTEXT, new Jex());
        TYPES.put(JAVALIN_CONTEXT, new Javalin());
        TYPES.put(HELIDON_REQ, new Helidon());
        TYPES.put(HELIDON_RES, new Helidon());
    }

    static interface Handler {
        public void factoryInterface(Append var1, String var2);

        public void addImports(Set<String> var1);

        public void writeCreateMethod(Append var1, String var2);

        public String argumentName(String var1);
    }

    private static class Jex
    implements Handler {
        private Jex() {
        }

        @Override
        public void factoryInterface(Append writer, String parentType) {
            writer.append("BeanFactory<%s, %s>", parentType, "Context");
        }

        @Override
        public void addImports(Set<String> importTypes) {
            importTypes.add("io.avaje.inject.spi.BeanFactory");
            importTypes.add(RequestScope.JEX_CONTEXT);
        }

        @Override
        public void writeCreateMethod(Append writer, String parentType) {
            writer.append("  public %s create(Context context) {", parentType).eol();
        }

        @Override
        public String argumentName(String paramType) {
            return "context";
        }
    }

    private static class Javalin
    implements Handler {
        private Javalin() {
        }

        @Override
        public void factoryInterface(Append writer, String parentType) {
            writer.append("BeanFactory<%s, %s>", parentType, "Context");
        }

        @Override
        public void addImports(Set<String> importTypes) {
            importTypes.add("io.avaje.inject.spi.BeanFactory");
            importTypes.add(RequestScope.JAVALIN_CONTEXT);
        }

        @Override
        public void writeCreateMethod(Append writer, String parentType) {
            writer.append("  public %s create(Context context) {", parentType).eol();
        }

        @Override
        public String argumentName(String paramType) {
            return "context";
        }
    }

    private static class Helidon
    implements Handler {
        private Helidon() {
        }

        @Override
        public void factoryInterface(Append writer, String parentType) {
            writer.append("BeanFactory2<%s, %s, %s>", parentType, "ServerRequest", "ServerResponse");
        }

        @Override
        public void addImports(Set<String> importTypes) {
            importTypes.add("io.avaje.inject.spi.BeanFactory2");
            importTypes.add(RequestScope.HELIDON_REQ);
            importTypes.add(RequestScope.HELIDON_RES);
        }

        @Override
        public void writeCreateMethod(Append writer, String parentType) {
            writer.append("  public %s create(ServerRequest request, ServerResponse response) {", parentType).eol();
        }

        @Override
        public String argumentName(String paramType) {
            if (paramType.equals(RequestScope.HELIDON_RES)) {
                return "response";
            }
            return "request";
        }
    }
}

