/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

class ScopeUtil {
    private static final String INJECT_MODULE = "io.avaje.inject.InjectModule";

    ScopeUtil() {
    }

    static List<String> readProvides(Element element) {
        return ScopeUtil.readClasses(element, "provides");
    }

    static List<String> readRequires(Element element) {
        return ScopeUtil.readClasses(element, "requires");
    }

    static List<String> readClasses(Element element, String attributeName) {
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<String> requiresList = new ArrayList<String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!INJECT_MODULE.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().toString().startsWith(attributeName)) continue;
                for (Object requiresType : (List)entry.getValue().getValue()) {
                    String fullName = requiresType.toString();
                    fullName = fullName.substring(0, fullName.length() - 6);
                    requiresList.add(fullName);
                }
            }
        }
        return requiresList;
    }

    static String name(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos > -1) {
            name = name.substring(pos + 1);
        }
        if (name.endsWith("Scope")) {
            name = name.substring(0, name.length() - 5);
        }
        if (name.endsWith("Module")) {
            name = name.substring(0, name.length() - 6);
        }
        return ScopeUtil.camelCase(name);
    }

    private static String camelCase(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean upper = true;
        for (char aChar : name.toCharArray()) {
            if (Character.isLetterOrDigit(aChar)) {
                if (upper) {
                    aChar = Character.toUpperCase(aChar);
                    upper = false;
                }
                sb.append(aChar);
                continue;
            }
            if (!ScopeUtil.toUpperOn(aChar)) continue;
            upper = true;
        }
        return sb.toString();
    }

    private static boolean toUpperOn(char aChar) {
        return aChar == ' ' || aChar == '-' || aChar == '_';
    }
}

