/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

class SimpleBeanWriter {
    private static final String CODE_COMMENT = "/**\n * Generated source - dependency injection builder for %s.\n */";
    private static final String CODE_COMMENT_FACTORY = "/**\n * Generated source - dependency injection factory for request scoped %s.\n */";
    private static final String CODE_COMMENT_BUILD = "  /**\n   * Create and register %s.\n   */";
    private final BeanReader beanReader;
    private final ProcessingContext context;
    private final String originName;
    private final String shortName;
    private final String packageName;
    private final String suffix;
    private Append writer;

    SimpleBeanWriter(BeanReader beanReader, ProcessingContext context) {
        this.beanReader = beanReader;
        this.context = context;
        TypeElement origin = beanReader.getBeanType();
        this.originName = origin.getQualifiedName().toString();
        this.shortName = origin.getSimpleName().toString();
        this.packageName = Util.packageOf(this.originName);
        this.suffix = beanReader.suffix();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.context.createWriter(this.originName + this.suffix);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        if (this.isRequestScopedController()) {
            this.writeRequestCreate();
        } else {
            this.writeGenericTypeFields();
            this.writeGenericProviders();
            this.writeStaticFactoryMethod();
            this.writeStaticFactoryBeanMethods();
        }
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeGenericProviders() {
        Set<GenericType> genericTypes = this.beanReader.getGenericTypes();
        if (genericTypes != null && !genericTypes.isEmpty()) {
            for (GenericType type : genericTypes) {
                String sn = type.shortName();
                this.writer.append("  public static Provider<");
                type.writeShort(this.writer);
                this.writer.append("> provider%s(Builder builder) {", sn).eol();
                this.writer.append("    return builder.getProviderFor(%s.class, TYPE_%s);", this.shortName, sn).eol();
                this.writer.append("  }").eol();
            }
            this.writer.eol();
        }
    }

    private void writeGenericTypeFields() {
        Set<GenericType> genericTypes = this.beanReader.getGenericTypes();
        if (genericTypes != null && !genericTypes.isEmpty()) {
            for (GenericType type : genericTypes) {
                this.writer.append("  public static final Type TYPE_%s = new GenericType<", type.shortName());
                type.writeShort(this.writer);
                this.writer.append(">(){};").eol();
            }
            this.writer.eol();
        }
    }

    private void writeRequestCreate() {
        this.beanReader.writeRequestCreate(this.writer);
    }

    private boolean isRequestScopedController() {
        return this.beanReader.isRequestScopedController();
    }

    private void writeStaticFactoryBeanMethods() {
        for (MethodReader factoryMethod : this.beanReader.getFactoryMethods()) {
            this.writeFactoryBeanMethod(factoryMethod);
        }
    }

    private void writeFactoryBeanMethod(MethodReader method) {
        method.commentBuildMethod(this.writer);
        this.writer.append("  public static void build_%s(Builder builder) {", method.getName()).eol();
        method.buildAddFor(this.writer);
        this.writer.append(method.builderGetFactory()).eol();
        this.writer.append(method.builderBuildBean()).eol();
        method.builderBuildAddBean(this.writer);
        this.writer.append("    }").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeStaticFactoryMethod() {
        MethodReader constructor = this.beanReader.getConstructor();
        if (constructor == null) {
            this.context.logError(this.beanReader.getBeanType(), "Unable to determine constructor to use for %s? Add explicit @Inject to one of the constructors.", this.beanReader.getBeanType());
            return;
        }
        this.writeBuildMethodStart(constructor);
        this.writeAddFor(constructor);
        this.writer.append("  }").eol().eol();
    }

    private void writeAddFor(MethodReader constructor) {
        this.beanReader.buildAddFor(this.writer);
        this.writeCreateBean(constructor);
        this.beanReader.buildRegister(this.writer);
        this.beanReader.addLifecycleCallbacks(this.writer);
        if (this.beanReader.isExtraInjectionRequired()) {
            this.writeExtraInjection();
        }
        this.writer.append("    }").eol();
    }

    private void writeBuildMethodStart(MethodReader constructor) {
        int providerIndex = 0;
        this.writer.append(CODE_COMMENT_BUILD, this.shortName).eol();
        this.writer.append("  public static void build(Builder builder");
        for (MethodReader.MethodParam param : constructor.getParams()) {
            if (!param.isGenericParam()) continue;
            param.addProviderParam(this.writer, providerIndex++);
        }
        for (MethodReader methodReader : this.beanReader.getInjectMethods()) {
            for (MethodReader.MethodParam param : methodReader.getParams()) {
                if (!param.isGenericParam()) continue;
                param.addProviderParam(this.writer, providerIndex++);
            }
        }
        this.writer.append(") {").eol();
    }

    private void writeCreateBean(MethodReader constructor) {
        this.writer.append("      %s bean = new %s(", this.shortName, this.shortName);
        this.writeMethodParams("builder", constructor);
    }

    private void writeExtraInjection() {
        this.writer.append("      builder.addInjector(b -> {").eol();
        this.writer.append("        // field and method injection").eol();
        this.injectFields();
        this.injectMethods();
        this.writer.append("      });").eol();
    }

    private void injectFields() {
        for (FieldReader fieldReader : this.beanReader.getInjectFields()) {
            String fieldName = fieldReader.getFieldName();
            String getDependency = fieldReader.builderGetDependency();
            this.writer.append("        $bean.%s = %s;", fieldName, getDependency).eol();
        }
    }

    private void injectMethods() {
        for (MethodReader methodReader : this.beanReader.getInjectMethods()) {
            this.writer.append("        $bean.%s(", methodReader.getName());
            this.writeMethodParams("b", methodReader);
        }
    }

    private void writeMethodParams(String builderRef, MethodReader methodReader) {
        List<MethodReader.MethodParam> methodParams = methodReader.getParams();
        for (int i = 0; i < methodParams.size(); ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            this.writer.append(methodParams.get(i).builderGetDependency(builderRef));
        }
        this.writer.append(");").eol();
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append(CODE_COMMENT_FACTORY, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT, this.shortName).eol();
        }
        this.writer.append("@Generated(\"io.avaje.inject.generator\")").eol();
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append("@Singleton").eol();
        }
        this.writer.append("public class ").append(this.shortName).append(this.suffix).append(" ");
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append("implements ");
            this.beanReader.factoryInterface(this.writer);
        }
        this.writer.append(" {").eol().eol();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }
}

