/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.Util;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class TypeAppender {
    private final Set<String> importTypes;
    private final Set<String> types = new LinkedHashSet<String>();
    private final Set<GenericType> genericTypes = new LinkedHashSet<GenericType>();

    TypeAppender(Set<String> importTypes) {
        this.importTypes = importTypes;
    }

    void add(String classType) {
        this.importTypes.add(classType);
        this.types.add(Util.shortName(classType) + ".class");
    }

    void add(List<String> types) {
        for (String type : types) {
            if (GenericType.isGeneric(type)) {
                this.genericTypes.add(GenericType.parse(type));
                continue;
            }
            this.add(type);
        }
    }

    Set<GenericType> genericTypes() {
        return this.genericTypes;
    }

    String asString() {
        if (!this.genericTypes.isEmpty()) {
            for (GenericType genericType : this.genericTypes) {
                this.types.add("TYPE_" + genericType.shortName());
            }
        }
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (String type : this.types) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(type);
        }
        return sb.toString();
    }
}

