/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Util;

class UtilType {
    private final Type type;
    private final String rawType;

    private UtilType(Type type, String rawType) {
        this.type = type;
        this.rawType = rawType;
    }

    static UtilType of(String rawType) {
        if (rawType.startsWith("java.util.List<")) {
            return new UtilType(Type.LIST, rawType);
        }
        if (rawType.startsWith("java.util.Set<")) {
            return new UtilType(Type.SET, rawType);
        }
        if (rawType.startsWith("java.util.Optional<")) {
            return new UtilType(Type.OPTIONAL, rawType);
        }
        if (Util.isProvider(rawType)) {
            return new UtilType(Type.PROVIDER, rawType);
        }
        return new UtilType(Type.OTHER, rawType);
    }

    String rawType() {
        switch (this.type) {
            case SET: {
                return Util.extractSet(this.rawType);
            }
            case LIST: {
                return Util.extractList(this.rawType);
            }
            case OPTIONAL: {
                return Util.extractOptionalType(this.rawType);
            }
        }
        return this.rawType;
    }

    String getMethod(boolean nullable) {
        switch (this.type) {
            case SET: {
                return "set(";
            }
            case LIST: {
                return "list(";
            }
            case OPTIONAL: {
                return "getOptional(";
            }
            case PROVIDER: {
                return "getProvider(";
            }
        }
        return nullable ? "getNullable(" : "get(";
    }

    private static enum Type {
        LIST,
        SET,
        OPTIONAL,
        PROVIDER,
        OTHER;

    }
}

