package io.avaje.inject.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import java.util.HashMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

/** A Prism representing a {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} annotation. */ 
@Generated("avaje-prism-generator")
final class DependencyMetaPrism {
  /** store prism value of type */
  private final String _type;

  /** store prism value of name */
  private final String _name;

  /** store prism value of importedComponent */
  private final Boolean _importedComponent;

  /** store prism value of method */
  private final String _method;

  /** store prism value of providesAspect */
  private final String _providesAspect;

  /** store prism value of provides */
  private final List<String> _provides;

  /** store prism value of dependsOn */
  private final List<String> _dependsOn;

  /** store prism value of autoProvides */
  private final String _autoProvides;

  public static final String PRISM_TYPE = "io.avaje.inject.spi.DependencyMeta";

  /**
   * An instance of the Values inner class whose
   * methods return the AnnotationValues used to build this prism. 
   * Primarily intended to support using Messager.
   */
  final Values values;

  /** Returns true if the mirror is an instance of {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} is present on the element, else false.
   *
   * @param mirror mirror. 
   * @return true if prism is present. 
   */
  static boolean isInstance(AnnotationMirror mirror) {
    return getInstance(mirror) != null;
  }

  /** Returns true if {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} is present on the element, else false.
   *
   * @param element element. 
   * @return true if annotation is present on the element. 
   */
  static boolean isPresent(Element element) {
    return getInstanceOn(element) != null;
  }

  /** Return a prism representing the {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} annotation present on the given element. 
   * similar to {@code element.getAnnotation(DependencyMeta.class)} except that 
   * an instance of this class rather than an instance of {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta}
   * is returned.
   *
   * @param element element. 
   * @return prism on element or null if no annotation is found. 
   */
  static DependencyMetaPrism getInstanceOn(Element element) {
    final var mirror = getMirror(element);
    if (mirror == null) return null;
    return getInstance(mirror);
  }

  /** Return a Optional representing a nullable {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} annotation on the given element. 
   * similar to {@code element.getAnnotation(io.avaje.inject.spi.DependencyMeta.class)} except that 
   * an Optional of this class rather than an instance of {@link io.avaje.inject.spi.DependencyMeta}
   * is returned.
   *
   * @param element element. 
   * @return prism optional for element. 
   */
  static Optional<DependencyMetaPrism> getOptionalOn(Element element) {
    final var mirror = getMirror(element);
    if (mirror == null) return Optional.empty();
    return getOptional(mirror);
  }

  /** Return a prism of the {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} annotation from an annotation mirror. 
   *
   * @param mirror mirror. 
   * @return prism for mirror or null if mirror is an incorrect type. 
   */
  static DependencyMetaPrism getInstance(AnnotationMirror mirror) {
    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return null;

    return new DependencyMetaPrism(mirror);
  }

  /** Return an Optional representing a nullable {@link DependencyMetaPrism @DependencyMetaPrism} from an annotation mirror. 
   * similar to {@code e.getAnnotation(io.avaje.inject.spi.DependencyMeta.class)} except that 
   * an Optional of this class rather than an instance of {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta}
   * is returned.
   *
   * @param mirror mirror. 
   * @return prism optional for mirror. 
   */
  static Optional<DependencyMetaPrism> getOptional(AnnotationMirror mirror) {
    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return Optional.empty();

    return Optional.of(new DependencyMetaPrism(mirror));
  }

  private DependencyMetaPrism(AnnotationMirror mirror) {
    for (final ExecutableElement key : mirror.getElementValues().keySet()) {
      memberValues.put(key.getSimpleName().toString(), mirror.getElementValues().get(key));
    }
    for (final ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
      defaults.put(member.getSimpleName().toString(), member.getDefaultValue());
    }
    _type = getValue("type", String.class);
    _name = getValue("name", String.class);
    _importedComponent = getValue("importedComponent", Boolean.class);
    _method = getValue("method", String.class);
    _providesAspect = getValue("providesAspect", String.class);
    _provides = getArrayValues("provides", String.class);
    _dependsOn = getArrayValues("dependsOn", String.class);
    _autoProvides = getValue("autoProvides", String.class);
    this.values = new Values(memberValues);
    this.mirror = mirror;
    this.isValid = valid;
  }

  /** 
   * Returns a String representing the value of the {@code java.lang.String type()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#type()
   */ 
  public String type() { return _type; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String name()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#name()
   */ 
  public String name() { return _name; }

  /** 
   * Returns a Boolean representing the value of the {@code boolean importedComponent()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#importedComponent()
   */ 
  public Boolean importedComponent() { return _importedComponent; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String method()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#method()
   */ 
  public String method() { return _method; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String providesAspect()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#providesAspect()
   */ 
  public String providesAspect() { return _providesAspect; }

  /** 
   * Returns a List&lt;String&gt; representing the value of the {@code provides()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#provides()
   */ 
  public List<String> provides() { return _provides; }

  /** 
   * Returns a List&lt;String&gt; representing the value of the {@code dependsOn()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#dependsOn()
   */ 
  public List<String> dependsOn() { return _dependsOn; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String autoProvides()} member of the Annotation.
   * @see io.avaje.inject.spi.DependencyMeta#autoProvides()
   */ 
  public String autoProvides() { return _autoProvides; }

  /**
   * Determine whether the underlying AnnotationMirror has no errors.
   * True if the underlying AnnotationMirror has no errors.
   * When true is returned, none of the methods will return null.
   * When false is returned, a least one member will either return null, or another
   * prism that is not valid.
   */
   final boolean isValid;
    
  /**
   * The underlying AnnotationMirror of the annotation
   * represented by this Prism. 
   * Primarily intended to support using Messager.
   */
   final AnnotationMirror mirror;
  /**
   * A class whose members corespond to those of {@link io.avaje.inject.spi.DependencyMeta @DependencyMeta} 
   * but which each return the AnnotationValue corresponding to
   * that member in the model of the annotations. Returns null for
   * defaulted members. Used for Messager, so default values are not useful.
   */
  static final class Values {
    private final Map<String, AnnotationValue> values;

    private Values(Map<String, AnnotationValue> values) {
      this.values = values;
    }    
    /** Return the AnnotationValue corresponding to the type() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue type(){ return values.get("type");}
    /** Return the AnnotationValue corresponding to the name() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue name(){ return values.get("name");}
    /** Return the AnnotationValue corresponding to the importedComponent() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue importedComponent(){ return values.get("importedComponent");}
    /** Return the AnnotationValue corresponding to the method() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue method(){ return values.get("method");}
    /** Return the AnnotationValue corresponding to the providesAspect() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue providesAspect(){ return values.get("providesAspect");}
    /** Return the AnnotationValue corresponding to the provides() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue provides(){ return values.get("provides");}
    /** Return the AnnotationValue corresponding to the dependsOn() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue dependsOn(){ return values.get("dependsOn");}
    /** Return the AnnotationValue corresponding to the autoProvides() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue autoProvides(){ return values.get("autoProvides");}
  }

  private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
  private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
  private boolean valid = true;

  private <T> T getValue(String name, Class<T> clazz) {
    final T result = DependencyMetaPrism.getValue(memberValues, defaults, name, clazz);
    if (result == null) valid = false;
    return result;
  }

  private <T> List<T> getArrayValues(String name, final Class<T> clazz) {
    final List<T> result = DependencyMetaPrism.getArrayValues(memberValues, defaults, name, clazz);
    if (result == null) valid = false;
    return result;
  }
  private static AnnotationMirror getMirror(Element target) {
    for (final var m : target.getAnnotationMirrors()) {
      final CharSequence mfqn = ((TypeElement) m.getAnnotationType().asElement()).getQualifiedName();
      if (PRISM_TYPE.contentEquals(mfqn)) return m;
    }
    return null;
  }

  private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
    AnnotationValue av = memberValues.get(name);
    if (av == null) av = defaults.get(name);
    if (av == null) {
      return null;
    }
    if (clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());
    return null;
  }

  private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, final Class<T> clazz) {
    AnnotationValue av = memberValues.get(name);
    if (av == null) av = defaults.get(name);
    if (av == null) {
      return List.of();
    }
    if (av.getValue() instanceof List) {
      final List<T> result = new ArrayList<>();
      for (final var v : getValueAsList(av)) {
        if (clazz.isInstance(v.getValue())) {
          result.add(clazz.cast(v.getValue()));
        } else {
          return List.of();
        }
      }
      return result;
    } else {
      return List.of();
    }
  }

  @SuppressWarnings("unchecked")
  private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
    return (List<AnnotationValue>) av.getValue();
  }
}
