/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.applog.AppLog;
import io.avaje.inject.BeanScope;
import io.avaje.inject.test.MetaInfo;
import io.avaje.inject.test.PluginInitialise;
import io.avaje.inject.test.TestBeanScope;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class InjectExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ExtensionContext.Store.CloseableResource {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.inject");
    private static final ExtensionContext.Namespace INJECT_NS = ExtensionContext.Namespace.create((Object[])new Object[]{"io.avaje.inject.InjectTest"});
    private static final String BEAN_SCOPE = "BEAN_SCOPE";
    private static final String META = "META";
    private static final ReentrantLock lock = new ReentrantLock();
    private static boolean started;
    private static BeanScope globalTestScope;

    public void close() {
        lock.lock();
        try {
            if (globalTestScope != null) {
                log.log(System.Logger.Level.DEBUG, "Closing global test BeanScope");
                globalTestScope.close();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void initialiseGlobalTestScope(ExtensionContext context) {
        globalTestScope = TestBeanScope.init(false);
        if (globalTestScope != null) {
            log.log(System.Logger.Level.TRACE, "register global test BeanScope with beans {0}", globalTestScope);
            context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)InjectExtension.class.getCanonicalName(), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) {
        lock.lock();
        try {
            if (!started) {
                this.initialiseGlobalTestScope(context);
                started = true;
            }
            MetaInfo metaInfo = this.createMetaInfo(context);
            this.putMetaInfo(context, metaInfo);
            if (metaInfo.hasStaticInjection()) {
                MetaInfo.Scope testClassBeanScope = metaInfo.buildForClass(globalTestScope);
                this.putClassScope(context, testClassBeanScope);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void putMetaInfo(ExtensionContext context, MetaInfo metaInfo) {
        Class testClass = context.getRequiredTestClass();
        context.getStore(INJECT_NS).put((Object)(META + testClass), (Object)metaInfo);
    }

    private MetaInfo getMetaInfo(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        return (MetaInfo)context.getStore(INJECT_NS).get((Object)(META + testClass));
    }

    private void putClassScope(ExtensionContext context, MetaInfo.Scope testClassBeanScope) {
        Class testClass = context.getRequiredTestClass();
        context.getStore(INJECT_NS).put((Object)(BEAN_SCOPE + testClass), (Object)testClassBeanScope);
    }

    private BeanScope getClassScope(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        MetaInfo.Scope pair = (MetaInfo.Scope)context.getStore(INJECT_NS).get((Object)(BEAN_SCOPE + testClass));
        return pair.beanScope();
    }

    public void beforeEach(ExtensionContext context) {
        MetaInfo metaInfo = this.getMetaInfo(context);
        if (metaInfo.hasNormalInjection()) {
            BeanScope parent = metaInfo.hasStaticInjection() ? this.getClassScope(context) : globalTestScope;
            MetaInfo.Scope beanScope = metaInfo.buildForInstance(parent, context.getRequiredTestInstance());
            Method testMethod = context.getRequiredTestMethod();
            context.getStore(INJECT_NS).put((Object)(BEAN_SCOPE + testMethod), (Object)beanScope);
        }
    }

    public void afterEach(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        AutoCloseable beanScope = (AutoCloseable)context.getStore(INJECT_NS).remove((Object)(BEAN_SCOPE + testMethod));
        if (beanScope != null) {
            try {
                beanScope.close();
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Error closing scope", (Throwable)e);
            }
        }
    }

    public void afterAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        AutoCloseable scope = (AutoCloseable)context.getStore(INJECT_NS).remove((Object)(BEAN_SCOPE + testClass));
        if (scope != null) {
            try {
                scope.close();
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Error closing scope", (Throwable)e);
            }
        }
    }

    private MetaInfo createMetaInfo(ExtensionContext context) {
        return new MetaInfo(context.getRequiredTestClass(), PluginInitialise.plugin());
    }
}

