/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.test.MetaInfo;
import io.avaje.inject.test.Plugin;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.util.reflection.GenericMaster;
import org.mockito.plugins.MemberAccessor;

class MetaReader {
    final List<Field> captors = new ArrayList<Field>();
    final List<FieldTarget> mocks = new ArrayList<FieldTarget>();
    final List<FieldTarget> spies = new ArrayList<FieldTarget>();
    final List<FieldTarget> injection = new ArrayList<FieldTarget>();
    final List<FieldTarget> staticMocks = new ArrayList<FieldTarget>();
    final List<FieldTarget> staticSpies = new ArrayList<FieldTarget>();
    final List<FieldTarget> staticInjection = new ArrayList<FieldTarget>();
    boolean classInjection;
    boolean instanceInjection;
    final Plugin plugin;
    boolean staticPlugin;
    boolean instancePlugin;

    MetaReader(Class<?> testClass, Plugin plugin) {
        this.plugin = plugin;
        for (Field field : testClass.getDeclaredFields()) {
            this.readField(field);
        }
    }

    boolean hasClassInjection() {
        return this.classInjection;
    }

    boolean hasInstanceInjection() {
        return this.instanceInjection;
    }

    public String toString() {
        Object s = this.toStringAppend("mocks:", this.mocks);
        s = (String)s + this.toStringAppend("spies:", this.spies);
        s = (String)s + this.toStringAppend("inject:", this.injection);
        s = (String)s + this.toStringAppend("captors:", this.captors);
        s = (String)s + this.toStringAppend("staticMocks:", this.staticMocks);
        s = (String)s + this.toStringAppend("staticSpies:", this.staticSpies);
        s = (String)s + this.toStringAppend("staticInjection:", this.staticInjection);
        return s;
    }

    private String toStringAppend(String key, List<?> entries) {
        return entries.isEmpty() ? "" : key + entries + "; ";
    }

    private void readField(Field field) {
        Mock mockAnnotation = field.getAnnotation(Mock.class);
        if (mockAnnotation != null) {
            this.add(this.newTarget(field), this.mocks, this.staticMocks);
            return;
        }
        Spy spyAnnotation = field.getAnnotation(Spy.class);
        if (spyAnnotation != null) {
            this.add(this.newTarget(field), this.spies, this.staticSpies);
            return;
        }
        Captor captorAnnotation = field.getAnnotation(Captor.class);
        if (captorAnnotation != null) {
            this.captors.add(field);
            return;
        }
        Inject injectAnnotation = field.getAnnotation(Inject.class);
        if (injectAnnotation != null) {
            FieldTarget target = this.newTarget(field);
            if (this.plugin != null && this.plugin.forType(target.type())) {
                target.markForPluginInjection();
                if (target.isStatic()) {
                    this.staticPlugin = true;
                } else {
                    this.instancePlugin = true;
                }
            }
            this.add(target, this.injection, this.staticInjection);
        }
    }

    private void add(FieldTarget target, List<FieldTarget> instanceList, List<FieldTarget> staticList) {
        if (target.isStatic()) {
            this.classInjection = true;
            staticList.add(target);
        } else {
            this.instanceInjection = true;
            instanceList.add(target);
        }
    }

    private FieldTarget newTarget(Field field) {
        return new FieldTarget(field, this.name(field));
    }

    private String name(Field field) {
        Named named = field.getAnnotation(Named.class);
        if (named != null) {
            return named.value().toLowerCase();
        }
        for (Annotation annotation : field.getAnnotations()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!metaAnnotation.annotationType().equals(Qualifier.class)) continue;
                return annotation.annotationType().getSimpleName().toLowerCase();
            }
        }
        return null;
    }

    MetaInfo.Scope setFromScope(BeanScope beanScope, Object testInstance) {
        if (testInstance != null) {
            return this.setForInstance(beanScope, testInstance);
        }
        return this.setForStatics(beanScope);
    }

    private MetaInfo.Scope setForInstance(BeanScope beanScope, Object testInstance) {
        try {
            Plugin.Scope pluginScope = this.instancePlugin ? this.plugin.createScope(beanScope) : null;
            for (Field field : this.captors) {
                this.set(field, this.captorFor(field), testInstance);
            }
            for (FieldTarget target : this.mocks) {
                target.setFromScope(beanScope, testInstance);
            }
            for (FieldTarget target : this.spies) {
                target.setFromScope(beanScope, testInstance);
            }
            for (FieldTarget target : this.injection) {
                if (target.pluginInjection) {
                    Object instance = pluginScope.create(target.type());
                    target.setFromPlugin(instance, testInstance);
                    continue;
                }
                target.setFromScope(beanScope, testInstance);
            }
            return new MetaInfo.Scope(beanScope, pluginScope);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private MetaInfo.Scope setForStatics(BeanScope beanScope) {
        try {
            Plugin.Scope pluginScope = this.staticPlugin ? this.plugin.createScope(beanScope) : null;
            for (FieldTarget target : this.staticMocks) {
                target.setFromScope(beanScope, null);
            }
            for (FieldTarget target : this.staticSpies) {
                target.setFromScope(beanScope, null);
            }
            for (FieldTarget target : this.staticInjection) {
                if (target.pluginInjection) {
                    Object instance = pluginScope.create(target.type());
                    target.setFromPlugin(instance, null);
                    continue;
                }
                target.setFromScope(beanScope, null);
            }
            return new MetaInfo.Scope(beanScope, pluginScope);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object captorFor(Field field) {
        Class<?> type = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(type)) {
            throw new IllegalStateException("@Captor field must be of the type ArgumentCaptor.\n Field: '" + field.getName() + "' has wrong type");
        }
        Class cls = new GenericMaster().getGenericType(field);
        return ArgumentCaptor.forClass((Class)cls);
    }

    void build(BeanScopeBuilder builder, Object testInstance) {
        if (testInstance != null) {
            this.buildForInstance(builder);
        } else {
            this.buildForStatics(builder);
        }
    }

    void buildForInstance(BeanScopeBuilder builder) {
        BeanScopeBuilder.ForTesting forTesting = builder.forTesting();
        for (FieldTarget target : this.mocks) {
            forTesting.mock(target.type(), target.name());
        }
        for (FieldTarget target : this.spies) {
            forTesting.spy(target.type(), target.name());
        }
    }

    void buildForStatics(BeanScopeBuilder builder) {
        BeanScopeBuilder.ForTesting forTesting = builder.forTesting();
        for (FieldTarget target : this.staticMocks) {
            forTesting.mock(target.type(), target.name());
        }
        for (FieldTarget target : this.staticSpies) {
            forTesting.spy(target.type(), target.name());
        }
    }

    void set(Field field, Object val, Object testInstance) throws IllegalAccessException {
        MemberAccessor memberAccessor = Plugins.getMemberAccessor();
        memberAccessor.set(field, testInstance, val);
    }

    class FieldTarget {
        private final Field field;
        private final String name;
        private final boolean isStatic;
        private boolean pluginInjection;

        FieldTarget(Field field, String name) {
            this.field = field;
            this.isStatic = Modifier.isStatic(field.getModifiers());
            this.name = name;
        }

        public String toString() {
            return this.field.getName();
        }

        Class<?> type() {
            return this.field.getType();
        }

        String name() {
            return this.name;
        }

        boolean isStatic() {
            return this.isStatic;
        }

        void setFromScope(BeanScope beanScope, Object testInstance) throws IllegalAccessException {
            MetaReader.this.set(this.field, beanScope.get(this.type(), this.name), testInstance);
        }

        void setFromPlugin(Object value, Object testInstance) throws IllegalAccessException {
            MetaReader.this.set(this.field, value, testInstance);
        }

        void markForPluginInjection() {
            this.pluginInjection = true;
        }
    }
}

