/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.test.MetaReader;
import io.avaje.inject.test.Plugin;

final class MetaInfo {
    private final MetaReader reader;

    MetaInfo(Class<?> testClass, Plugin plugin) {
        this.reader = new MetaReader(testClass, plugin);
    }

    boolean hasStaticInjection() {
        return this.reader.hasClassInjection();
    }

    boolean hasInstanceInjection() {
        return this.reader.hasInstanceInjection();
    }

    Scope buildForClass(BeanScope globalTestScope) {
        return this.buildSet(globalTestScope, null);
    }

    Scope buildForInstance(BeanScope globalTestScope, Object testInstance) {
        return this.buildSet(globalTestScope, testInstance);
    }

    private Scope buildSet(BeanScope parent, Object testInstance) {
        BeanScopeBuilder builder = BeanScope.builder();
        if (parent != null) {
            builder.parent(parent, false);
        }
        this.reader.build(builder, testInstance);
        BeanScope beanScope = builder.build();
        return this.reader.setFromScope(beanScope, testInstance);
    }

    static class Scope
    implements AutoCloseable {
        private final BeanScope beanScope;
        private final Plugin.Scope pluginScope;

        Scope(BeanScope beanScope, Plugin.Scope pluginScope) {
            this.beanScope = beanScope;
            this.pluginScope = pluginScope;
        }

        BeanScope beanScope() {
            return this.beanScope;
        }

        @Override
        public void close() {
            this.beanScope.close();
            if (this.pluginScope != null) {
                this.pluginScope.close();
            }
        }
    }
}

