/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.test.Setup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class SetupMethods {
    private final List<Method> staticMethods = new ArrayList<Method>();
    private final List<Method> instanceMethods = new ArrayList<Method>();

    SetupMethods(Class<?> testClass) {
        LinkedList hierarchy = new LinkedList();
        for (Class<?> analyzedClass = testClass; analyzedClass != null && !analyzedClass.equals(Object.class); analyzedClass = analyzedClass.getSuperclass()) {
            hierarchy.addFirst(analyzedClass);
        }
        for (Class clazz : hierarchy) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getDeclaredAnnotation(Setup.class) == null) continue;
                if (Modifier.isStatic(method.getModifiers())) {
                    method.setAccessible(true);
                    this.staticMethods.add(method);
                    continue;
                }
                method.setAccessible(true);
                this.instanceMethods.add(method);
            }
        }
    }

    boolean hasStaticMethods() {
        return !this.staticMethods.isEmpty();
    }

    boolean hasInstanceMethods() {
        return !this.instanceMethods.isEmpty();
    }

    void invokeStatics(BeanScopeBuilder builder) {
        try {
            for (Method method : this.staticMethods) {
                method.invoke(null, builder);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Expecting method with single argument of BeanScopeBuilder but ... ", e);
        }
    }

    void invokeInstance(BeanScopeBuilder builder, Object testInstance) {
        try {
            for (Method method : this.instanceMethods) {
                method.invoke(testInstance, builder);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Expecting method with single argument of BeanScopeBuilder but ... ", e);
        }
    }
}

