/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.spi.Builder;
import io.avaje.inject.spi.EnrichBean;
import io.avaje.inject.spi.Module;
import io.avaje.inject.spi.SuppliedBean;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DBeanScopeBuilder
implements BeanScopeBuilder.ForTesting {
    private static final Logger log = LoggerFactory.getLogger(DBeanScopeBuilder.class);
    private final List<SuppliedBean> suppliedBeans = new ArrayList<SuppliedBean>();
    private final List<EnrichBean> enrichBeans = new ArrayList<EnrichBean>();
    private final Set<Module> includeModules = new LinkedHashSet<Module>();
    private BeanScope parent;
    private boolean shutdownHook;

    DBeanScopeBuilder() {
    }

    @Override
    public BeanScopeBuilder.ForTesting forTesting() {
        return this;
    }

    @Override
    public BeanScopeBuilder withShutdownHook(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
        return this;
    }

    @Override
    public BeanScopeBuilder withModules(Module ... modules) {
        this.includeModules.addAll(Arrays.asList(modules));
        return this;
    }

    @Override
    public BeanScopeBuilder withBeans(Object ... beans) {
        for (Object bean : beans) {
            this.suppliedBeans.add(SuppliedBean.of(DBeanScopeBuilder.superOf(bean.getClass()), bean));
        }
        return this;
    }

    @Override
    public <D> BeanScopeBuilder withBean(Class<D> type, D bean) {
        return this.withBean(null, type, bean);
    }

    @Override
    public <D> BeanScopeBuilder withBean(String name, Class<D> type, D bean) {
        this.suppliedBeans.add(SuppliedBean.of(name, type, bean));
        return this;
    }

    @Override
    public <D> BeanScopeBuilder withBean(Type type, D bean) {
        return this.withBean(null, type, bean);
    }

    @Override
    public <D> BeanScopeBuilder withBean(String name, Type type, D bean) {
        this.suppliedBeans.add(SuppliedBean.ofType(name, type, bean));
        return this;
    }

    @Override
    public BeanScopeBuilder withParent(BeanScope parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public BeanScopeBuilder.ForTesting withMock(Class<?> type) {
        return this.withMock(type, null, null);
    }

    @Override
    public BeanScopeBuilder.ForTesting withMock(Class<?> type, String name) {
        return this.withMock(type, name, null);
    }

    @Override
    public <D> BeanScopeBuilder.ForTesting withMock(Class<D> type, Consumer<D> consumer) {
        return this.withMock(type, null, consumer);
    }

    private <D> BeanScopeBuilder.ForTesting withMock(Class<D> type, String name, Consumer<D> consumer) {
        this.suppliedBeans.add(SuppliedBean.of(name, type, null, consumer));
        return this;
    }

    @Override
    public BeanScopeBuilder.ForTesting withSpy(Class<?> type) {
        return this.spy(type, null, null);
    }

    @Override
    public BeanScopeBuilder.ForTesting withSpy(Class<?> type, String name) {
        return this.spy(type, name, null);
    }

    @Override
    public <D> BeanScopeBuilder.ForTesting withSpy(Class<D> type, Consumer<D> consumer) {
        return this.spy(type, null, consumer);
    }

    private <D> BeanScopeBuilder.ForTesting spy(Class<D> type, String name, Consumer<D> consumer) {
        this.enrichBeans.add(new EnrichBean<D>(type, name, consumer));
        return this;
    }

    @Override
    public BeanScope build() {
        Set<String> moduleNames;
        FactoryOrder factoryOrder = new FactoryOrder(this.includeModules, !this.suppliedBeans.isEmpty());
        if (factoryOrder.isEmpty()) {
            ServiceLoader.load(Module.class).forEach(factoryOrder::add);
        }
        if ((moduleNames = factoryOrder.orderFactories()).isEmpty()) {
            throw new IllegalStateException("No modules found. When using java module system we need an explicit provides clause in module-info like:\n\n provides io.avaje.inject.spi.BeanContextFactory with org.example._DI$BeanContextFactory;\n\n Otherwise perhaps using Gradle and IDEA but with a setup issue? Review IntelliJ Settings / Build / Build tools / Gradle - 'Build and run using' value and set that to 'Gradle'.  Refer to https://avaje.io/inject#gradle");
        }
        log.debug("building with modules {}", moduleNames);
        Builder builder = Builder.newBuilder(this.suppliedBeans, this.enrichBeans, this.parent);
        for (Module factory : factoryOrder.factories()) {
            factory.build(builder);
        }
        return builder.build(this.shutdownHook);
    }

    private static Class<?> superOf(Class<?> suppliedClass) {
        Class<?> suppliedSuper = suppliedClass.getSuperclass();
        if (Object.class.equals(suppliedSuper)) {
            return suppliedClass;
        }
        return suppliedSuper;
    }

    static class FactoryOrder {
        private final boolean suppliedBeans;
        private final Set<String> moduleNames = new LinkedHashSet<String>();
        private final List<Module> factories = new ArrayList<Module>();
        private final List<FactoryState> queue = new ArrayList<FactoryState>();
        private final List<FactoryState> queueNoDependencies = new ArrayList<FactoryState>();
        private final Map<String, FactoryList> providesMap = new HashMap<String, FactoryList>();

        FactoryOrder(Set<Module> includeModules, boolean suppliedBeans) {
            this.factories.addAll(includeModules);
            this.suppliedBeans = suppliedBeans;
            for (Module includeModule : includeModules) {
                this.moduleNames.add(includeModule.getClass().getTypeName());
            }
        }

        void add(Module factory) {
            FactoryState wrappedFactory = new FactoryState(factory);
            this.providesMap.computeIfAbsent(factory.getClass().getTypeName(), s -> new FactoryList()).add(wrappedFactory);
            if (!this.isEmpty(factory.provides())) {
                for (Class<?> feature : factory.provides()) {
                    this.providesMap.computeIfAbsent(feature.getTypeName(), s -> new FactoryList()).add(wrappedFactory);
                }
            }
            if (this.isEmpty(factory.requires())) {
                if (!this.isEmpty(factory.provides())) {
                    this.push(wrappedFactory);
                } else {
                    this.queueNoDependencies.add(wrappedFactory);
                }
            } else {
                this.queue.add(wrappedFactory);
            }
        }

        private boolean isEmpty(Class<?>[] values) {
            return values == null || values.length == 0;
        }

        private void push(FactoryState factory) {
            factory.setPushed();
            this.factories.add(factory.factory());
            this.moduleNames.add(factory.getClass().getTypeName());
        }

        Set<String> orderFactories() {
            for (FactoryState factoryState : this.queueNoDependencies) {
                this.push(factoryState);
            }
            this.processQueue();
            return this.moduleNames;
        }

        List<Module> factories() {
            return this.factories;
        }

        private void processQueue() {
            int count;
            while ((count = this.processQueuedFactories()) > 0) {
            }
            if (this.suppliedBeans) {
                for (FactoryState factoryState : this.queue) {
                    this.push(factoryState);
                }
            } else if (!this.queue.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (FactoryState factory : this.queue) {
                    sb.append("Module [").append(factory.getClass()).append("] has unsatisfied dependencies on modules:");
                    for (Class<?> depModuleName : factory.requires()) {
                        if (this.moduleNames.contains(depModuleName)) continue;
                        sb.append(String.format(" [%s]", depModuleName));
                    }
                }
                sb.append(". Modules that were loaded ok are:").append(this.moduleNames);
                sb.append(". Maybe need to add external dependencies via BeanScopeBuilder.withBean()?");
                throw new IllegalStateException(sb.toString());
            }
        }

        private int processQueuedFactories() {
            int count = 0;
            Iterator<FactoryState> it = this.queue.iterator();
            while (it.hasNext()) {
                FactoryState factory = it.next();
                if (!this.satisfiedDependencies(factory)) continue;
                it.remove();
                this.push(factory);
                ++count;
            }
            return count;
        }

        private boolean satisfiedDependencies(FactoryState factory) {
            for (Class<?> moduleOrFeature : factory.requires()) {
                FactoryList factories = this.providesMap.get(moduleOrFeature.getTypeName());
                if (factories != null && factories.allPushed()) continue;
                return false;
            }
            return true;
        }

        boolean isEmpty() {
            return this.factories.isEmpty();
        }
    }

    private static class FactoryList {
        private final List<FactoryState> factories = new ArrayList<FactoryState>();

        private FactoryList() {
        }

        void add(FactoryState factory) {
            this.factories.add(factory);
        }

        boolean allPushed() {
            for (FactoryState factory : this.factories) {
                if (factory.isPushed()) continue;
                return false;
            }
            return true;
        }
    }

    private static class FactoryState {
        private final Module factory;
        private boolean pushed;

        private FactoryState(Module factory) {
            this.factory = factory;
        }

        void setPushed() {
            this.pushed = true;
        }

        boolean isPushed() {
            return this.pushed;
        }

        Module factory() {
            return this.factory;
        }

        Class<?>[] requires() {
            return this.factory.requires();
        }
    }
}

