/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.DContextEntry;
import io.avaje.inject.spi.DContextEntryBean;
import io.avaje.inject.spi.DEntry;
import io.avaje.inject.spi.KeyUtil;
import io.avaje.inject.spi.SuppliedBean;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class DBeanMap {
    private final Map<String, DContextEntry> beans = new LinkedHashMap<String, DContextEntry>();
    private NextBean nextBean;

    DBeanMap() {
    }

    void addAll(Map<DContextEntryBean, DEntry> map) {
        for (Map.Entry<String, DContextEntry> entry : this.beans.entrySet()) {
            for (DContextEntryBean contentEntry : entry.getValue().entries()) {
                map.computeIfAbsent(contentEntry, dContextEntryBean -> contentEntry.entry()).addKey(entry.getKey());
            }
        }
    }

    void add(List<SuppliedBean> suppliedBeans) {
        for (SuppliedBean suppliedBean : suppliedBeans) {
            this.addSuppliedBean(suppliedBean);
        }
    }

    private void addSuppliedBean(SuppliedBean supplied) {
        Type suppliedType = supplied.type();
        DContextEntryBean entryBean = DContextEntryBean.of(supplied.bean(), supplied.name(), 2);
        this.beans.computeIfAbsent(suppliedType.getTypeName(), s -> new DContextEntry()).add(entryBean);
        for (Class<?> anInterface : supplied.interfaces()) {
            this.beans.computeIfAbsent(anInterface.getTypeName(), s -> new DContextEntry()).add(entryBean);
        }
    }

    void register(int flag, Object bean) {
        DContextEntryBean entryBean = DContextEntryBean.of(bean, this.nextBean.name, flag);
        for (Type type : this.nextBean.types) {
            this.beans.computeIfAbsent(type.getTypeName(), s -> new DContextEntry()).add(entryBean);
        }
    }

    <T> T get(Type type, String name) {
        DContextEntry entry = this.beans.get(type.getTypeName());
        if (entry == null) {
            return null;
        }
        return (T)entry.get(KeyUtil.lower(name));
    }

    List<Object> all(Type type) {
        DContextEntry entry = this.beans.get(type.getTypeName());
        return entry != null ? entry.all() : Collections.emptyList();
    }

    boolean isSupplied(String qualifierName, Type ... types) {
        if (types != null) {
            for (Type type : types) {
                if (!this.isSuppliedType(qualifierName, type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSuppliedType(String qualifierName, Type type) {
        DContextEntry entry = this.beans.get(type.getTypeName());
        return entry != null && entry.isSupplied(qualifierName);
    }

    void nextBean(String name, Type[] types) {
        this.nextBean = new NextBean(name, types);
    }

    NextBean next() {
        return this.nextBean;
    }

    static class NextBean {
        final String name;
        final Type[] types;

        NextBean(String name, Type[] types) {
            this.name = name;
            this.types = types;
        }
    }
}

