/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.BeanEntry;
import io.avaje.inject.BeanScope;
import io.avaje.inject.Priority;
import io.avaje.inject.spi.DBeanMap;
import io.avaje.inject.spi.DContextEntryBean;
import io.avaje.inject.spi.DEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DBeanScope
implements BeanScope {
    private static final Logger log = LoggerFactory.getLogger(DBeanScope.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final List<Runnable> postConstruct;
    private final List<AutoCloseable> preDestroy;
    private final DBeanMap beans;
    private final ShutdownHook shutdownHook;
    private final BeanScope parent;
    private boolean shutdown;
    private boolean closed;

    DBeanScope(boolean withShutdownHook, List<AutoCloseable> preDestroy, List<Runnable> postConstruct, DBeanMap beans, BeanScope parent) {
        this.preDestroy = preDestroy;
        this.postConstruct = postConstruct;
        this.beans = beans;
        this.parent = parent;
        if (withShutdownHook) {
            this.shutdownHook = new ShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            this.shutdownHook = null;
        }
    }

    @Override
    public List<BeanEntry> all() {
        IdentityHashMap<DContextEntryBean, DEntry> map = new IdentityHashMap<DContextEntryBean, DEntry>();
        if (this.parent != null) {
            ((DBeanScope)this.parent).addAll(map);
        }
        this.addAll(map);
        return new ArrayList<BeanEntry>(map.values());
    }

    void addAll(Map<DContextEntryBean, DEntry> map) {
        this.beans.addAll(map);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.get(type, null);
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        return this.getByType(type, name);
    }

    @Override
    public <T> T get(Type type, String name) {
        return this.getByType(type, name);
    }

    private <T> T getByType(Type type, String name) {
        Object bean = this.beans.get(type, name);
        if (bean != null) {
            return bean;
        }
        return this.parent == null ? null : (T)this.parent.get(type, name);
    }

    @Override
    public <T> List<T> list(Class<T> interfaceType) {
        List<Object> values = this.beans.all(interfaceType);
        if (this.parent == null) {
            return values;
        }
        return DBeanScope.combine(values, this.parent.list(interfaceType));
    }

    static <T> List<T> combine(List<T> values, List<T> parentValues) {
        if (values.isEmpty()) {
            return parentValues;
        }
        if (parentValues.isEmpty()) {
            return values;
        }
        values.addAll(parentValues);
        return values;
    }

    @Override
    public <T> List<T> listByPriority(Class<T> interfaceType) {
        return this.listByPriority(interfaceType, Priority.class);
    }

    @Override
    public <T> List<T> listByPriority(Class<T> interfaceType, Class<? extends Annotation> priorityAnnotation) {
        List<T> list = this.list(interfaceType);
        return list.size() > 1 ? this.sortByPriority(list, priorityAnnotation) : list;
    }

    private <T> List<T> sortByPriority(List<T> list, Class<? extends Annotation> priorityAnnotation) {
        boolean priorityUsed = false;
        ArrayList<SortBean> tempList = new ArrayList<SortBean>(list.size());
        for (T bean : list) {
            SortBean sortBean = new SortBean(bean, priorityAnnotation);
            tempList.add(sortBean);
            if (priorityUsed || !sortBean.priorityDefined) continue;
            priorityUsed = true;
        }
        if (!priorityUsed) {
            return list;
        }
        Collections.sort(tempList);
        ArrayList<Object> sorted = new ArrayList<Object>(tempList.size());
        for (SortBean sortBean : tempList) {
            sorted.add(sortBean.bean);
        }
        return sorted;
    }

    @Override
    public List<Object> listByAnnotation(Class<?> annotation) {
        List<Object> values = this.beans.all(annotation);
        if (this.parent == null) {
            return values;
        }
        return DBeanScope.combine(values, this.parent.listByAnnotation(annotation));
    }

    DBeanScope start() {
        this.lock.lock();
        try {
            log.trace("firing postConstruct");
            for (Runnable invoke : this.postConstruct) {
                invoke.run();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.shutdownHook != null && !this.shutdown) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            if (!this.closed) {
                this.closed = true;
                log.trace("firing preDestroy");
                for (AutoCloseable closeable : this.preDestroy) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        log.error("Error during PreDestroy lifecycle method", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
            this.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class ShutdownHook
    extends Thread {
        private final DBeanScope scope;

        ShutdownHook(DBeanScope scope) {
            this.scope = scope;
        }

        @Override
        public void run() {
            this.scope.shutdown();
        }
    }

    private static class SortBean<T>
    implements Comparable<SortBean<T>> {
        private final T bean;
        private boolean priorityDefined;
        private final int priority;

        SortBean(T bean, Class<? extends Annotation> priorityAnnotation) {
            this.bean = bean;
            this.priority = this.initPriority(priorityAnnotation);
        }

        int initPriority(Class<? extends Annotation> priorityAnnotation) {
            try {
                Annotation ann = this.bean.getClass().getDeclaredAnnotation(priorityAnnotation);
                if (ann != null) {
                    int priority = (Integer)priorityAnnotation.getMethod("value", new Class[0]).invoke((Object)ann, new Object[0]);
                    this.priorityDefined = true;
                    return priority;
                }
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Problem instantiating @Priority", e);
            }
            return 5000;
        }

        @Override
        public int compareTo(SortBean<T> o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

