/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.Builder;
import io.avaje.inject.spi.DBeanMap;
import io.avaje.inject.spi.DBeanScope;
import io.avaje.inject.spi.ProviderPromise;
import io.avaje.inject.spi.ProviderWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Provider;

class DBuilder
implements Builder {
    private final List<Runnable> postConstruct = new ArrayList<Runnable>();
    private final List<AutoCloseable> preDestroy = new ArrayList<AutoCloseable>();
    private final List<Consumer<Builder>> injectors = new ArrayList<Consumer<Builder>>();
    protected final DBeanMap beanMap = new DBeanMap();
    private final BeanScope parent;
    private Type injectTarget;
    private boolean runningPostConstruct;

    DBuilder(BeanScope parent) {
        this.parent = parent;
    }

    @Override
    public boolean isAddBeanFor(Type ... types) {
        return this.isAddBeanFor((String)null, types);
    }

    @Override
    public boolean isAddBeanFor(String name, Type ... types) {
        this.next(name, types);
        return true;
    }

    protected void next(String name, Type ... types) {
        this.injectTarget = this.firstOf(types);
        this.beanMap.nextBean(name, types);
    }

    private Type firstOf(Type[] types) {
        return types != null && types.length > 0 ? types[0] : null;
    }

    @Override
    public <T> Set<T> set(Class<T> interfaceType) {
        return new LinkedHashSet<T>(this.list(interfaceType));
    }

    @Override
    public <T> List<T> list(Class<T> interfaceType) {
        List<Object> values = this.beanMap.all(interfaceType);
        if (this.parent == null) {
            return values;
        }
        return DBeanScope.combine(values, this.parent.list(interfaceType));
    }

    private <T> T getMaybe(Type type, String name) {
        Object bean = this.beanMap.get(type, name);
        if (bean != null) {
            return bean;
        }
        return this.parent == null ? null : (T)this.parent.get(type, name);
    }

    protected <T> T enrich(T bean, DBeanMap.NextBean next) {
        return bean;
    }

    @Override
    public <T> T register(T bean) {
        return this.register(0, bean);
    }

    @Override
    public <T> T registerPrimary(T bean) {
        return this.register(1, bean);
    }

    @Override
    public <T> T registerSecondary(T bean) {
        return this.register(-1, bean);
    }

    private <T> T register(int flag, T bean) {
        bean = this.enrich(bean, this.beanMap.next());
        this.beanMap.register(flag, bean);
        return bean;
    }

    @Override
    public <T> void withBean(Class<T> type, T bean) {
        this.next(null, type);
        this.beanMap.register(2, bean);
    }

    @Override
    public void addPostConstruct(Runnable invoke) {
        this.postConstruct.add(invoke);
    }

    @Override
    public void addPreDestroy(AutoCloseable invoke) {
        this.preDestroy.add(invoke);
    }

    @Override
    public void addInjector(Consumer<Builder> injector) {
        this.injectors.add(injector);
    }

    @Override
    public <T> Optional<T> getOptional(Class<T> cls) {
        return this.getOptional(cls, null);
    }

    @Override
    public <T> Optional<T> getOptional(Class<T> cls, String name) {
        T bean = this.getMaybe(cls, name);
        return Optional.ofNullable(bean);
    }

    @Override
    public <T> T getNullable(Class<T> cls) {
        return this.getNullable(cls, null);
    }

    @Override
    public <T> T getNullable(Class<T> cls, String name) {
        return this.getMaybe(cls, name);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> cls) {
        return this.getProvider(cls, null);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> cls, String name) {
        if (this.runningPostConstruct) {
            return new ProviderWrapper<T>(this.get(cls, name));
        }
        ProviderPromise<T> promise = new ProviderPromise<T>(cls, name);
        this.injectors.add(promise);
        return promise;
    }

    @Override
    public <T> Provider<T> getProviderFor(Class<?> cls, Type type) {
        return () -> {
            Object bean = this.getMaybe(cls, null);
            if (bean == null) {
                bean = this.getMaybe(type, null);
            }
            if (bean != null) {
                return bean;
            }
            String msg = "Unable to inject an instance for generic type " + type + " usually provided by " + cls + "?";
            throw new IllegalStateException(msg);
        };
    }

    @Override
    public <T> T get(Class<T> cls) {
        return this.get(cls, null);
    }

    @Override
    public <T> T get(Class<T> cls, String name) {
        T bean = this.getMaybe(cls, name);
        if (bean == null) {
            String msg = "Injecting null for " + cls.getName();
            if (name != null) {
                msg = msg + " name:" + name;
            }
            List<T> beanList = this.list(cls);
            msg = msg + " when creating " + this.injectTarget + " - potential beans to inject: " + beanList;
            if (!beanList.isEmpty()) {
                msg = msg + ". Check @Named or Qualifier being used";
            }
            msg = msg + ". Check for missing module? [ missing beanScopeBuilder.withModules() ]";
            msg = msg + ". If it is expected to be externally provided, missing beanScopeBuilder.withBean() ?";
            throw new IllegalStateException(msg);
        }
        return bean;
    }

    private void runInjectors() {
        this.runningPostConstruct = true;
        for (Consumer<Builder> injector : this.injectors) {
            injector.accept(this);
        }
    }

    @Override
    public BeanScope build(boolean withShutdownHook) {
        this.runInjectors();
        return new DBeanScope(withShutdownHook, this.preDestroy, this.postConstruct, this.beanMap, this.parent).start();
    }
}

