/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.DBeanMap;
import io.avaje.inject.spi.DBuilder;
import io.avaje.inject.spi.EnrichBean;
import io.avaje.inject.spi.KeyUtil;
import io.avaje.inject.spi.SuppliedBean;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DBuilderExtn
extends DBuilder {
    private final Map<String, EnrichBean> enrichMap = new HashMap<String, EnrichBean>();
    private final boolean hasSuppliedBeans;

    DBuilderExtn(BeanScope parent, List<SuppliedBean> suppliedBeans, List<EnrichBean> enrichBeans) {
        super(parent);
        boolean bl = this.hasSuppliedBeans = suppliedBeans != null && !suppliedBeans.isEmpty();
        if (this.hasSuppliedBeans) {
            this.beanMap.add(suppliedBeans);
        }
        if (enrichBeans != null && !enrichBeans.isEmpty()) {
            for (EnrichBean spy : enrichBeans) {
                this.enrichMap.put(spy.key(), spy);
            }
        }
    }

    @Override
    public boolean isAddBeanFor(String qualifierName, Type ... types) {
        this.next(qualifierName, types);
        if (this.hasSuppliedBeans) {
            return !this.beanMap.isSupplied(qualifierName, types);
        }
        return true;
    }

    @Override
    protected <T> T enrich(T bean, DBeanMap.NextBean next) {
        EnrichBean<T> enrich = this.enrichLookup(bean.getClass(), next.name);
        if (enrich != null) {
            return enrich.enrich(bean);
        }
        for (Type type : next.types) {
            enrich = this.enrichLookup(type, next.name);
            if (enrich == null) continue;
            return enrich.enrich(bean);
        }
        return bean;
    }

    private <T> EnrichBean<T> enrichLookup(Type type, String name) {
        EnrichBean enrich = this.enrichMap.get(KeyUtil.key(type, null));
        if (enrich == null && name != null) {
            enrich = this.enrichMap.get(KeyUtil.key(type, name));
        }
        return enrich;
    }
}

