/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.DContextEntryBean;
import java.util.ArrayList;
import java.util.List;

class DContextEntry {
    private final List<DContextEntryBean> entries = new ArrayList<DContextEntryBean>(5);

    DContextEntry() {
    }

    List<DContextEntryBean> entries() {
        return this.entries;
    }

    void add(DContextEntryBean entryBean) {
        this.entries.add(entryBean);
    }

    Object get(String name) {
        if (this.entries.size() == 1) {
            return this.entries.get(0).getBean();
        }
        return new EntryMatcher(name).match(this.entries);
    }

    List<Object> all() {
        ArrayList<Object> list = new ArrayList<Object>(this.entries.size());
        for (DContextEntryBean entry : this.entries) {
            list.add(entry.getBean());
        }
        return list;
    }

    boolean isSupplied(String qualifierName) {
        for (DContextEntryBean entry : this.entries) {
            if (!entry.isSupplied(qualifierName)) continue;
            return true;
        }
        return false;
    }

    static class EntryMatcher {
        private final String name;
        private final boolean impliedName;
        private DContextEntryBean match;
        private DContextEntryBean ignoredSecondaryMatch;

        EntryMatcher(String name) {
            if (name != null && name.startsWith("!")) {
                this.name = name.substring(1);
                this.impliedName = true;
            } else {
                this.name = name;
                this.impliedName = false;
            }
        }

        Object match(List<DContextEntryBean> entries) {
            for (DContextEntryBean entry : entries) {
                if (!entry.isNameMatch(this.name)) continue;
                this.checkMatch(entry);
            }
            if (this.match == null && this.impliedName) {
                for (DContextEntryBean entry : entries) {
                    if (!entry.isNameMatch(null)) continue;
                    this.checkMatch(entry);
                }
            }
            return this.candidate();
        }

        private void checkMatch(DContextEntryBean entry) {
            if (this.match == null) {
                this.match = entry;
                return;
            }
            if (this.match.isSupplied()) {
                return;
            }
            if (entry.isSupplied()) {
                this.match = entry;
                return;
            }
            if (this.match.isSecondary() && !entry.isSecondary()) {
                this.match = entry;
                return;
            }
            if (this.match.isPrimary()) {
                if (entry.isPrimary()) {
                    throw new IllegalStateException("Expecting only 1 bean match but have multiple primary beans " + this.match.getBean() + " and " + entry.getBean());
                }
                return;
            }
            if (entry.isSecondary()) {
                if (this.match.isSecondary()) {
                    this.ignoredSecondaryMatch = entry;
                }
                return;
            }
            if (entry.isPrimary()) {
                this.match = entry;
                return;
            }
            if (this.match.isNameEqual(this.name) && !entry.isNameEqual(this.name)) {
                this.ignoredSecondaryMatch = entry;
                return;
            }
            if (!this.match.isNameEqual(this.name) && entry.isNameEqual(this.name)) {
                this.match = entry;
                return;
            }
            throw new IllegalStateException("Expecting only 1 bean match but have multiple matching beans " + this.match.getBean() + " and " + entry.getBean() + ". Maybe need a rebuild is required after adding a @Named qualifier?");
        }

        private Object candidate() {
            if (this.match == null) {
                return null;
            }
            this.checkSecondary();
            return this.match.getBean();
        }

        private void checkSecondary() {
            if (this.match.isSecondary() && this.ignoredSecondaryMatch != null) {
                throw new IllegalStateException("Expecting only 1 bean match but have multiple secondary beans " + this.match.getBean() + " and " + this.ignoredSecondaryMatch.getBean());
            }
        }
    }
}

