/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.DEntry;
import io.avaje.inject.spi.KeyUtil;
import java.util.Objects;
import javax.inject.Provider;

class DContextEntryBean {
    protected final Object source;
    private final String name;
    private final int flag;

    public static DContextEntryBean of(Object bean, String name, int flag) {
        if (bean instanceof Provider) {
            return new Prov(bean, name, flag);
        }
        return new DContextEntryBean(bean, name, flag);
    }

    private DContextEntryBean(Object source, String name, int flag) {
        this.source = source;
        this.name = KeyUtil.lower(name);
        this.flag = flag;
    }

    DEntry entry() {
        return new DEntry(this.name, this.flag, this.getBean());
    }

    boolean isNameMatch(String qualifierName) {
        return qualifierName == null || qualifierName.equals(this.name);
    }

    boolean isNameEqual(String qualifierName) {
        return Objects.equals(qualifierName, this.name);
    }

    Object getBean() {
        return this.source;
    }

    boolean isPrimary() {
        return this.flag == 1;
    }

    boolean isSecondary() {
        return this.flag == -1;
    }

    boolean isSupplied() {
        return this.flag == 2;
    }

    boolean isSupplied(String qualifierName) {
        return this.flag == 2 && (qualifierName == null || qualifierName.equals(this.name));
    }

    static class Prov
    extends DContextEntryBean {
        private Object actualBean;

        private Prov(Object provider, String name, int flag) {
            super(provider, name, flag);
        }

        @Override
        Object getBean() {
            if (this.actualBean == null) {
                this.actualBean = ((Provider)this.source).get();
            }
            return this.actualBean;
        }
    }
}

