/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.render.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import io.avaje.jex.Context;
import io.avaje.jex.spi.TemplateRender;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;

public class FreeMarkerRender
implements TemplateRender {
    private final Configuration configuration;

    public FreeMarkerRender(Configuration configuration) {
        this.configuration = configuration;
    }

    public FreeMarkerRender() {
        this.configuration = this.defaultConfiguration();
    }

    private Configuration defaultConfiguration() {
        Configuration configuration = new Configuration(new Version(2, 3, 26));
        configuration.setClassForTemplateLoading(FreeMarkerRender.class, "/");
        return configuration;
    }

    public String[] defaultExtensions() {
        return new String[]{"ftl"};
    }

    public void render(Context context, String filePath, Map<String, Object> model) {
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = this.configuration.getTemplate(filePath);
            template.process(model, (Writer)stringWriter);
            context.html(stringWriter.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TemplateException e) {
            throw new IllegalStateException(e);
        }
    }
}

