/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.metrics.ebean;

import io.avaje.applog.AppLog;
import io.avaje.metrics.Metric;
import io.avaje.metrics.MetricSupplier;
import io.avaje.metrics.stats.CounterStats;
import io.avaje.metrics.stats.TimerStats;
import io.ebean.Database;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.ServerMetrics;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseMetricSupplier
implements MetricSupplier {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.metrics.ebean");
    final Database database;

    public DatabaseMetricSupplier(Database database) {
        this.database = database;
    }

    public List<Metric.Statistics> collectMetrics() {
        ArrayList<Metric.Statistics> metrics = new ArrayList<Metric.Statistics>();
        ServerMetrics dbMetrics = this.database.metaInfo().collectMetrics();
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, dbMetrics.asJson().withHash(false).withNewLine(false).json());
        }
        for (MetaTimedMetric timedMetric : dbMetrics.timedMetrics()) {
            metrics.add((Metric.Statistics)new TimerStats(timedMetric.name(), timedMetric.count(), timedMetric.total(), timedMetric.max()));
        }
        for (MetaQueryMetric metric : dbMetrics.queryMetrics()) {
            metrics.add((Metric.Statistics)new TimerStats(metric.name(), metric.count(), metric.total(), metric.max()));
        }
        for (MetaQueryMetric metric : dbMetrics.countMetrics()) {
            metrics.add((Metric.Statistics)new CounterStats(metric.name(), metric.count()));
        }
        return metrics;
    }
}

