package io.avaje.prism.internal;

import java.io.PrintWriter;

public class UTypeWriter {
  private UTypeWriter() {}

  public static void write(PrintWriter out, String packageName) {

    out.append(
        "package "
            + packageName
            + ";\n"
            + "\n"
            + "import java.util.List;\n"
            + "import java.util.Set;\n"
            + "\n"
            + "import javax.annotation.processing.Generated;\n"
            + "import javax.lang.model.element.AnnotationMirror;\n"
            + "import javax.lang.model.type.TypeKind;\n"
            + "import javax.lang.model.type.TypeMirror;\n"
            + "\n"
            + "/** Utility type to help process {@link TypeMirror}s */\n"
            + "@Generated(\"avaje-prism-generator\")\n"
            + "public interface UType {\n"
            + "\n"
            + "  /**\n"
            + "   * Create a UType from the given TypeMirror.\n"
            + "   *\n"
            + "   * @param mirror type mirror to analyze\n"
            + "   * @return Create the UType from the given TypeMirror.\n"
            + "   */\n"
            + "  static UType parse(TypeMirror mirror) {\n"
            + "\n"
            + "    return TypeMirrorVisitor.create(mirror);\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Return all the import types needed to write this mirror in source code (annotations included).\n"
            + "   *\n"
            + "   * @return Return the import types required.\n"
            + "   */\n"
            + "  Set<String> importTypes();\n"
            + "\n"
            + "  /**\n"
            + "   * Return the full type as a code safe string. (with annotations if present)\n"
            + "   *\n"
            + "   * @return the full typeName\n"
            + "   */\n"
            + "  String full();\n"
            + "\n"
            + "  /**\n"
            + "   *  Return the main type (outermost type). e.g for mirror {@ java.util.List<Something> you'll get java.util.List\n"
            + "   *\n"
            + "   * @return the outermost type\n"
            + "   */\n"
            + "  String mainType();\n"
            + "\n"
            + "  /**\n"
            + "   * Return the full (but unqualified) type as a code safe string. Use in tandem with {@link\n"
            + "   * #importTypes()} to generate readable code\n"
            + "   *\n"
            + "   * @return the short name with unqualified type\n"
            + "   */\n"
            + "  String shortType();\n"
            + "\n"
            + "  /**\n"
            + "   * Return the first generic parameter.\n"
            + "   *\n"
            + "   * @see UType#componentTypes\n"
            + "   */\n"
            + "  default UType param0() {\n"
            + "    return null;\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Return the second componentType.\n"
            + "   *\n"
            + "   * @see UType#componentTypes\n"
            + "   */\n"
            + "  default UType param1() {\n"
            + "    return null;\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Retrieve the component types associated with this mirror.\n"
            + "   *\n"
            + "   * <ul>\n"
            + "   *   <li>{@link TypeKind#ARRAY}: will contain the array componentType\n"
            + "   *   <li>{@link TypeKind#DECLARED}: will contain the generic parameters\n"
            + "   *   <li>{@link TypeKind#TYPEVAR}: will contain the upper bound for the type variable\n"
            + "   *   <li>{@link TypeKind#WILDCARD}: will contain the extends bound or super bound\n"
            + "   *   <li>{@link TypeKind#INTERSECTION}: will contain the bounds of the intersection\n"
            + "   *   <li>{@link TypeKind#UNION}: will contain the alternative types\n"
            + "   * </ul>\n"
            + "   *\n"
            + "   * @return the component types\n"
            + "   */\n"
            + "  default List<UType> componentTypes() {\n"
            + "    return List.of();\n"
            + "  }\n"
            + "\n"
            + "  /** The {@link TypeKind} of the type mirror used to create this Utype. */\n"
            + "  TypeKind kind();\n"
            + "\n"
            + "  /**\n"
            + "   * Returns whether the type mirror is generic\n"
            + "   *\n"
            + "   * @return whether the type is generic\n"
            + "   */\n"
            + "  default boolean isGeneric() {\n"
            + "    return false;\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Return the annotation mirrors directly on the type.\n"
            + "   *\n"
            + "   * <p>For a {@code UType} representing {@code @NotEmpty Map<@Notblank String, Object>} you will\n"
            + "   * get mirrors for {@code @NotEmpty} only\n"
            + "   *\n"
            + "   * @return the annotations directly present\n"
            + "   */\n"
            + "  default List<AnnotationMirror> annotations() {\n"
            + "    return List.of();\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Return the annotation mirrors directly on the type and in within generic type use.\n"
            + "   *\n"
            + "   * <p>For a {@code UType} representing {@code @NotEmpty Map<@Notblank String, Object>} you will\n"
            + "   * get mirrors for {@code @NotEmpty} and {@code @Notblank}\n"
            + "   *\n"
            + "   * @return all annotations present on this type\n"
            + "   */\n"
            + "  default List<AnnotationMirror> allAnnotationsInType() {\n"
            + "    return List.of();\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Return the full type as a string, stripped of annotations.\n"
            + "   *\n"
            + "   * @return full type, but without annotations\n"
            + "   */\n"
            + "  default String fullWithoutAnnotations() {\n"
            + "    return ProcessorUtils.trimAnnotations(full()).replace(\",\", \", \");\n"
            + "  }\n"
            + "\n"
            + "  /**\n"
            + "   * Return the short type as a string, stripped of annotations.\n"
            + "   *\n"
            + "   * @return short type, but without annotations\n"
            + "   */\n"
            + "  default String shortWithoutAnnotations() {\n"
            + "    return ProcessorUtils.trimAnnotations(shortType()).replace(\",\", \", \");\n"
            + "  }\n\n"
            + "  /** Compare whether the current full() type is identical to the given UType's full() type */\n"
            + "  @Override\n"
            + "  boolean equals(Object other);"
            + "}");
  }
}
