/*
Copyright (c) 2006,2007, Bruce Chapman

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation and/or
      other materials provided with the distribution.
    * Neither the name of the Hickory project nor the names of its contributors
      may be used to endorse or promote products derived from this software without
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * package-info.java
 *
 * Created on 12 August 2006, 20:44
 *
 */

/**
 * Annotations and processors for creating Prisms which are partial reflections of known
 * annotations.
 *
 * <p>The problem: When writing annotation processors the two conventional mechanisms to access the
 * annotations in the source code are both awkward. {@code Element.getAnnotation()} can throw
 * Exceptions if the annotation being modelled is not semantically correct, and the member methods
 * on the returned Annotation can also throw Exceptions if the annotation being modelled is not
 * semantically correct. Moreover when calling a member with a {@code Class} return type, you need
 * to catch an exception to extract the TypeMirror.
 *
 * <p>On the other hand, AnnotationMirror and AnnotationValue do a good job of modelling both
 * correct and incorrect annotations, but provide no simple mechanism to determine whether it is
 * correct or incorrect, and provide no convenient functionality to access the member values in a
 * simple type specific way. While AnnotationMirror and AnnotationValue provide an ideal mechanism
 * for dealing with unknown annotations, they are inconvenient for reading member values from known
 * annotations.
 *
 * <p>A Prism provides a solution to this problem by combining the advantages of the pure reflective
 * model of AnnotationMirror and the runtime (real) model provided by {@code
 * Element.getAnnotation()}, hence the term Prism to capture this idea of partial reflection.
 *
 * <p>A Mirror is where you look for a reflection whereas a Prism is where you look for a partial
 * reflection. A {@code Prism} provides a partially reflective and partially real view of an {@code
 * Annotation}.
 *
 * <p>A Prism class is generated by using the {@code @GeneratePrism} annotation, or several can be
 * grouped together using {@code @GeneratePrisms}. The generated prisms have a complete set of
 * javadoc for reference.
 *
 * <p>An instance of a Prism is obtained by calling the generated prism's factory method {@code
 * getInstance(AnnotationMirror)} to obtain a prism corresponding to an annotation mirror, or the
 * factory method {@code getInstanceOn(Element)} to obtain an instance corresponding to an
 * annotation on the specified Element.
 *
 * <p>A prism has the same member methods as the annotation except that the return types are
 * translated from runtime types to compile time types as follows...
 *
 * <ul>
 *   <li>Primitive members return their equivalent wrapper class in the prism.
 *   <li>Class members return a {@link javax.lang.model.type.TypeMirror TypeMirror} from the mirror
 *       API.
 *   <li>Enum members return a String being the name of the enum constant (because the constant
 *       value in the mirror API might not match those available in the runtime it cannot
 *       consistently return the appropriate enum).
 *   <li>String members return Strings.
 *   <li>Annotation members return a Prism of the annotation. If a prism for that annotation is
 *       generated from the same @GeneratePrisms annotation as the prism that uses it, then an
 *       instance of that prism will be returned. Otherwise a Prism for that annotation is supplied
 *       as an inner class of the dependant Prism. the name of which is the simple name of the
 *       referenced annotation type.
 *   <li>Array members return a {@code List<X>} where X is the appropriate prism mapping of the
 *       array component as above.
 * </ul>
 *
 * If a prism instance represents a semantically incorrect annotation then its {@code isValid} field
 * will be false, and the member(s) with the erroneous value will return null. If {@code isValid} is
 * {@code true} then no members will return null. AnnotatonProcessors using a prism should ignore
 * any prism instance that is invalid. It can be assumed that the processing tool itself will
 * indicate an error to the user in this case.
 *
 * <p>The {@code mirror} field provides access to the underlying AnnotationMirror to assist with
 * using the Messager.
 *
 * <p>The {@code values} field contains an object whose methods have the same signature as the
 * annotation's methods but return the corresponding AnnotationValue or null if that member of the
 * Annotation does not have a value. This is provided for use when using Messager which can take an
 * AnnotationValue as a hint as to the message's position in the source code.
 *
 * <p>To generate a prism of a known annotation to be used by an AnnotationProcessor, use the {@link
 * io.avaje.prism.GeneratePrism @GeneratePrism} annotation on either the Processor itself, or the
 * package, compile once and the prism should be generated. The Processor for {@code @GeneratePrism}
 * will be discovered automatically using the {@link java.util.ServiceLoader} mechanism if the
 * annotation processing tool supports that means of discovery process.
 *
 * <p>If the processor needs to access prisms for more than one annotation type, use {@link
 * io.avaje.prism.GeneratePrisms @GeneratePrisms} to group together all the {@code @GeneratePrism}
 * annotations needed.
 */
@GeneratePrism(GeneratePrisms.class)
package io.avaje.prism;
