/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.Util;
import javax.lang.model.element.TypeElement;

final class AdapterName {
    final String shortName;
    final String adapterPackage;
    final String fullName;

    AdapterName(TypeElement origin) {
        String originName = origin.getQualifiedName().toString();
        String name = origin.getSimpleName().toString();
        String originPackage = ProcessorUtils.packageOf(originName);
        if (origin.getNestingKind().isNested()) {
            String parent = Util.shortName(originPackage);
            originPackage = ProcessorUtils.packageOf(originPackage);
            this.shortName = parent + "$" + name;
        } else {
            this.shortName = name;
        }
        this.adapterPackage = "".equals(originPackage) ? "valid" : originPackage + ".valid";
        this.fullName = this.adapterPackage + "." + this.shortName + "ValidationAdapter";
    }

    String shortName() {
        return this.shortName;
    }

    String adapterPackage() {
        return this.adapterPackage;
    }

    String fullName() {
        return this.fullName;
    }
}

