/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.ElementAnnotationContainer;
import io.avaje.validation.generator.PatternPrism;
import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class AnnotationUtil {
    private static final Map<String, String> KNOWN_TYPES;
    static Set<String> NUMBER_TYPES;
    private static final String[] NUMBER_TYPE_ONLY_ANNOTATIONS;
    private static final String[] BOOLEAN_TYPE_ONLY_ANNOTATIONS;
    private static final String[] STRING_TYPE_ONLY_ANNOTATIONS;
    private static final String[] TEMPORAL_ONLY_ANNOTATIONS;
    private static final Handler defaultHandler;
    private static final Map<String, Handler> handlers;

    private static void register(Handler handler, String key) {
        handlers.put("io.avaje.validation.constraints." + key, handler);
        handlers.put("jakarta.validation.constraints." + key, handler);
    }

    static String lookupType(TypeMirror typeMirror) {
        String rawType = ProcessorUtils.trimAnnotations(typeMirror.toString());
        String val = KNOWN_TYPES.get(rawType);
        if (val != null) {
            return val;
        }
        if (APContext.isAssignable(rawType, "java.math.BigDecimal")) {
            return "BigDecimal";
        }
        if (APContext.isAssignable(rawType, "java.math.BigInteger")) {
            return "BigInteger";
        }
        if (APContext.isAssignable(rawType, "java.lang.Number")) {
            return "Number";
        }
        if (APContext.isAssignable(rawType, "java.lang.CharSequence")) {
            return "CharSequence";
        }
        if (APContext.isAssignable(rawType, "java.time.temporal.Temporal")) {
            return "Temporal." + Util.shortName(rawType);
        }
        if (APContext.isAssignable(rawType, "java.util.Date")) {
            return "Temporal.Date";
        }
        if (rawType.contains("[]")) {
            return "Array";
        }
        return null;
    }

    private AnnotationUtil() {
    }

    static String annotationAttributeMap(AnnotationMirror annotationMirror, Element target) {
        Element element = annotationMirror.getAnnotationType().asElement();
        Handler handler = handlers.get(element.toString());
        return Objects.requireNonNullElse(handler, defaultHandler).attributes(annotationMirror, element, target);
    }

    static String[] splitString(String input, String delimiter) {
        Pattern pattern = Pattern.compile(delimiter + "(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
        return pattern.split(input);
    }

    private static String avajeKey(String messageKey) {
        return messageKey.replace("{jakarta.validation.constraints.", "{avaje.");
    }

    static {
        String[] keys;
        KNOWN_TYPES = new HashMap<String, String>();
        KNOWN_TYPES.put("byte", "Byte");
        KNOWN_TYPES.put("java.lang.Byte", "Byte");
        KNOWN_TYPES.put("short", "Short");
        KNOWN_TYPES.put("java.lang.Short", "Short");
        KNOWN_TYPES.put("int", "Integer");
        KNOWN_TYPES.put("java.lang.Integer", "Integer");
        KNOWN_TYPES.put("java.util.OptionalInt", "Integer");
        KNOWN_TYPES.put("long", "Long");
        KNOWN_TYPES.put("java.lang.Long", "Long");
        KNOWN_TYPES.put("java.util.OptionalLong", "Long");
        KNOWN_TYPES.put("float", "Float");
        KNOWN_TYPES.put("java.lang.Float", "Float");
        KNOWN_TYPES.put("double", "Double");
        KNOWN_TYPES.put("java.lang.Double", "Double");
        KNOWN_TYPES.put("java.util.OptionalDouble", "Double");
        KNOWN_TYPES.put("java.math.BigDecimal", "BigDecimal");
        KNOWN_TYPES.put("java.math.BigInteger", "BigInteger");
        KNOWN_TYPES.put("java.lang.String", "String");
        KNOWN_TYPES.put("java.lang.CharSequence", "String");
        KNOWN_TYPES.put("boolean", "Boolean");
        KNOWN_TYPES.put("java.lang.Boolean", "Boolean");
        NUMBER_TYPES = new HashSet<String>();
        NUMBER_TYPES.add("Byte");
        NUMBER_TYPES.add("Short");
        NUMBER_TYPES.add("Integer");
        NUMBER_TYPES.add("Long");
        NUMBER_TYPES.add("Float");
        NUMBER_TYPES.add("Double");
        NUMBER_TYPES.add("BigDecimal");
        NUMBER_TYPES.add("BigInteger");
        NUMBER_TYPES.add("Number");
        NUMBER_TYPE_ONLY_ANNOTATIONS = new String[]{"Max", "Min", "Positive", "PositiveOrZero", "Negative", "NegativeOrZero"};
        BOOLEAN_TYPE_ONLY_ANNOTATIONS = new String[]{"AssertTrue", "AssertFalse"};
        STRING_TYPE_ONLY_ANNOTATIONS = new String[]{"NotBlank", "Email"};
        TEMPORAL_ONLY_ANNOTATIONS = new String[]{"Past", "PastOrPresent", "Future", "FutureOrPresent", "DateRange"};
        defaultHandler = new StandardHandler();
        handlers = new HashMap<String, Handler>();
        PatternHandler pattern = new PatternHandler();
        AnnotationUtil.register(pattern, "Pattern");
        DecimalHandler decimalHandler = new DecimalHandler();
        for (String string : List.of("DecimalMax", "DecimalMin")) {
            AnnotationUtil.register(decimalHandler, string);
        }
        TypeCheckingHandler numberHandler = new TypeCheckingHandler(new HandlerMeta(NUMBER_TYPES, "non-numeric", false));
        for (String key : NUMBER_TYPE_ONLY_ANNOTATIONS) {
            AnnotationUtil.register(numberHandler, key);
        }
        TypeCheckingHandler typeCheckingHandler = new TypeCheckingHandler(new HandlerMeta(Set.of("Boolean"), "non-boolean", true));
        for (String key : BOOLEAN_TYPE_ONLY_ANNOTATIONS) {
            AnnotationUtil.register(typeCheckingHandler, key);
        }
        TypeCheckingHandler temporalHandler = new TypeCheckingHandler(new TemporalMeta());
        for (String key : TEMPORAL_ONLY_ANNOTATIONS) {
            AnnotationUtil.register(temporalHandler, key);
        }
        TypeCheckingHandler stringOnlyHandler = new TypeCheckingHandler(new HandlerMeta(Set.of("String", "CharSequence"), "non-string", true));
        for (String key : STRING_TYPE_ONLY_ANNOTATIONS) {
            AnnotationUtil.register(stringOnlyHandler, key);
        }
        CommonHandler commonHandler = new CommonHandler();
        for (String key : keys = new String[]{"Null", "NotNull", "NotEmpty", "Length", "Range", "Size", "Digits", "URI", "UUID"}) {
            AnnotationUtil.register(commonHandler, key);
        }
    }

    static interface Handler {
        public String attributes(AnnotationMirror var1, Element var2, Element var3);
    }

    static class StandardHandler
    extends BaseHandler {
        protected final AnnotationMirror annotationMirror;
        protected final Element element;
        protected final Element target;
        protected final String _type;

        StandardHandler() {
            this.annotationMirror = null;
            this.element = null;
            this.target = null;
            this._type = null;
        }

        StandardHandler(AnnotationMirror annotationMirror, Element element, Element target) {
            this.annotationMirror = annotationMirror;
            this.element = element;
            this.target = target;
            this._type = AnnotationUtil.lookupType(target.asType());
        }

        @Override
        public String attributes(AnnotationMirror annotationMirror, Element element, Element target) {
            return new StandardHandler(annotationMirror, element, target).writeAttributes();
        }

        String writeAttributes() {
            this.validate();
            for (ExecutableElement member : ElementFilter.methodsIn(this.element.getEnclosedElements())) {
                AnnotationValue value = this.annotationMirror.getElementValues().get(member);
                AnnotationValue defaultValue = member.getDefaultValue();
                if (value == null && defaultValue == null) continue;
                this.writeAttribute(member.getSimpleName(), value, defaultValue);
            }
            this.writeTypeAttribute();
            this.sb.append(")");
            return this.sb.toString();
        }

        protected void writeTypeAttribute() {
            if (this._type != null) {
                this.writeAttributeKey("_type");
                this.sb.append('\"').append(this._type).append('\"');
            }
        }

        void writeAttribute(Name simpleName, AnnotationValue value, AnnotationValue defaultValue) {
            this.writeAttributeKey(simpleName.toString());
            if (value != null) {
                this.writeVal(this.sb, value);
            } else {
                this.writeVal(this.sb, defaultValue);
            }
        }

        void writeAttributeKey(String name) {
            if (!this.first) {
                this.sb.append(", ");
            }
            this.first = false;
            this.sb.append("\"").append(name).append("\",");
        }

        AnnotationValue memberValue(String nameMatch) {
            for (ExecutableElement member : ElementFilter.methodsIn(this.element.getEnclosedElements())) {
                if (!nameMatch.equals(member.getSimpleName().toString())) continue;
                return this.annotationMirror.getElementValues().get(member);
            }
            return null;
        }
    }

    static class PatternHandler
    extends BaseHandler {
        PatternHandler() {
        }

        @Override
        public String attributes(AnnotationMirror annotationMirror, Element element, Element target) {
            return new PatternHandler().writeAttributes(annotationMirror);
        }

        String writeAttributes(AnnotationMirror annotationMirror) {
            Optional<PatternPrism> patternOp = PatternPrism.isInstance(annotationMirror);
            patternOp.ifPresent(p -> PatternHandler.pattern(this.sb, p));
            return this.sb.toString();
        }

        private static void pattern(StringBuilder sb, PatternPrism prism) {
            sb.append("\"regexp\",\"").append(prism.regexp()).append("\"");
            if (prism.message() != null) {
                sb.append(", \"message\",\"").append(AnnotationUtil.avajeKey(prism.message())).append("\"");
            }
            if (!prism.flags().isEmpty()) {
                sb.append(", \"flags\",List.of(").append(String.join((CharSequence)", ", prism.flags())).append(")");
            }
            if (!prism.groups().isEmpty()) {
                sb.append(", \"groups\",List.of(").append(String.join((CharSequence)", ", String.valueOf(prism.groups()) + ".class")).append(")");
            }
            sb.append(")");
        }
    }

    static class DecimalHandler
    extends CommonHandler {
        DecimalHandler() {
        }

        @Override
        public String attributes(AnnotationMirror annotationMirror, Element element, Element target) {
            return new DecimalHandler(annotationMirror, element, target).writeAttributes();
        }

        DecimalHandler(AnnotationMirror annotationMirror, Element element, Element target) {
            super(annotationMirror, element, target);
        }

        @Override
        String messageKey(AnnotationValue defaultValue) {
            AnnotationValue inclusiveValue = this.memberValue("inclusive");
            boolean inclusive = inclusiveValue == null || "true".equals(inclusiveValue.toString());
            String messageKey = super.messageKey(defaultValue);
            if (!inclusive) {
                messageKey = messageKey.replace(".message", ".exclusive.message");
            }
            return messageKey;
        }
    }

    static class TypeCheckingHandler
    extends CommonHandler {
        private final SupportedMeta meta;

        TypeCheckingHandler(SupportedMeta meta) {
            this.meta = meta;
        }

        TypeCheckingHandler(SupportedMeta meta, AnnotationMirror annotationMirror, Element element, Element target) {
            super(annotationMirror, element, target);
            this.meta = meta;
        }

        @Override
        public String attributes(AnnotationMirror annotationMirror, Element element, Element target) {
            return new TypeCheckingHandler(this.meta, annotationMirror, element, target).writeAttributes();
        }

        @Override
        void validate() {
            if (!this.meta.isSupported(this.target, this._type)) {
                APContext.logError(this.target, this.meta.message(this.annotationMirror, this.target), new Object[0]);
            }
        }
    }

    static final class HandlerMeta
    implements SupportedMeta {
        private final Set<String> supportedTypes;
        private final String message;
        private final boolean allowUnknown;

        HandlerMeta(Set<String> supportedTypes, String message, boolean allowUnknown) {
            this.supportedTypes = supportedTypes;
            this.message = message;
            this.allowUnknown = allowUnknown;
        }

        @Override
        public String message(AnnotationMirror annotationMirror, Element target) {
            return "Not allowed to use " + String.valueOf(annotationMirror) + " on a " + this.message + " type for " + String.valueOf(target);
        }

        @Override
        public boolean isSupported(Element target, String _type) {
            boolean isMetaConstraint = ElementAnnotationContainer.hasMetaConstraintAnnotation(target);
            return isMetaConstraint || this.allowUnknown && _type == null || _type != null && this.supportedTypes.contains(_type);
        }
    }

    static interface SupportedMeta {
        public String message(AnnotationMirror var1, Element var2);

        public boolean isSupported(Element var1, String var2);
    }

    static final class TemporalMeta
    implements SupportedMeta {
        TemporalMeta() {
        }

        @Override
        public String message(AnnotationMirror annotationMirror, Element target) {
            return "Not allowed to use " + String.valueOf(annotationMirror) + " on a non-temporal type for " + String.valueOf(target);
        }

        @Override
        public boolean isSupported(Element target, String _type) {
            boolean isMetaConstraint = ElementAnnotationContainer.hasMetaConstraintAnnotation(target);
            return isMetaConstraint || _type == null || _type.startsWith("Temporal.");
        }
    }

    static class CommonHandler
    extends StandardHandler {
        CommonHandler() {
        }

        CommonHandler(AnnotationMirror annotationMirror, Element element, Element target) {
            super(annotationMirror, element, target);
        }

        @Override
        public String attributes(AnnotationMirror annotationMirror, Element element, Element target) {
            return new CommonHandler(annotationMirror, element, target).writeAttributes();
        }

        @Override
        void writeAttribute(Name simpleName, AnnotationValue value, AnnotationValue defaultValue) {
            String name = simpleName.toString();
            if (value == null) {
                if ("message".equals(name)) {
                    this.writeAttributeKey("message");
                    this.sb.append(this.messageKey(defaultValue));
                } else if (!"payload".equals(name) && !"groups".equals(name)) {
                    super.writeAttribute(simpleName, null, defaultValue);
                }
            } else {
                super.writeAttribute(simpleName, value, defaultValue);
            }
        }

        String messageKey(AnnotationValue defaultValue) {
            return AnnotationUtil.avajeKey(defaultValue.toString());
        }
    }

    static abstract class BaseHandler
    implements Handler {
        final StringBuilder sb = new StringBuilder("Map.of(");
        boolean first = true;

        BaseHandler() {
        }

        void validate() {
        }

        final void writeVal(StringBuilder sb, AnnotationValue annotationValue) {
            Object value = annotationValue.getValue();
            if (value instanceof List) {
                sb.append("List.of(");
                boolean first = true;
                for (AnnotationValue listValue : (List)value) {
                    if (!first) {
                        sb.append(", ");
                    }
                    this.writeVal(sb, listValue);
                    first = false;
                }
                sb.append(")");
            } else if (value instanceof VariableElement) {
                VariableElement element = (VariableElement)value;
                sb.append(element.asType().toString()).append(".").append(element);
            } else if (value instanceof AnnotationMirror) {
                sb.append("\"Annotation Parameters Not Supported\"");
            } else {
                sb.append(annotationValue);
            }
        }

        final void writeVal(StringBuilder sb, Object value) {
            if (value instanceof List) {
                List l = (List)value;
                sb.append("List.of(");
                boolean first = true;
                for (Object listValue : l) {
                    if (!first) {
                        sb.append(", ");
                    }
                    this.writeVal(sb, listValue);
                    first = false;
                }
                sb.append(")");
            } else {
                sb.append(value);
            }
        }
    }
}

