/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.BeanReader;
import io.avaje.validation.generator.FieldReader;
import io.avaje.validation.generator.TypeReader;
import io.avaje.validation.generator.Util;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;

final class ClassReader
implements BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final List<FieldReader> allFields;
    private final Set<String> importTypes = new TreeSet<String>();
    private final TypeReader typeReader;
    private final boolean nonAccessibleField;

    ClassReader(TypeElement beanType) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        this.typeReader = new TypeReader(beanType);
        this.typeReader.process();
        this.nonAccessibleField = this.typeReader.nonAccessibleField();
        this.allFields = this.typeReader.allFields();
        this.importTypes.add("java.util.List");
        this.importTypes.add("java.util.Set");
        this.importTypes.add("java.util.Map");
        this.importTypes.add("io.avaje.validation.adapter.ValidationAdapter");
        this.importTypes.add("io.avaje.validation.adapter.ValidationContext");
        this.importTypes.add("io.avaje.validation.adapter.ValidationRequest");
        this.importTypes.add("io.avaje.validation.spi.Generated");
    }

    @Override
    public int genericTypeParamsCount() {
        return this.typeReader.genericTypeParamsCount();
    }

    public String toString() {
        return this.beanType.toString();
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public TypeElement getBeanType() {
        return this.beanType;
    }

    List<FieldReader> allFields() {
        return this.allFields;
    }

    @Override
    public boolean nonAccessibleField() {
        return this.nonAccessibleField;
    }

    @Override
    public boolean hasValidationAnnotation() {
        return Util.isValid(this.beanType);
    }

    @Override
    public void read() {
        for (FieldReader field : this.allFields) {
            field.addImports(this.importTypes);
        }
    }

    private Set<String> importTypes() {
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        for (FieldReader allField : this.allFields) {
            allField.addImports(this.importTypes);
        }
        return this.importTypes;
    }

    @Override
    public void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    @Override
    public void cascadeTypes(Set<String> types) {
        for (FieldReader allField : this.allFields) {
            allField.cascadeTypes(types);
        }
    }

    @Override
    public void writeFields(Append writer) {
        for (FieldReader allField : this.allFields) {
            allField.writeField(writer);
        }
        writer.eol();
    }

    @Override
    public void writeConstructor(Append writer) {
        for (FieldReader allField : this.allFields) {
            allField.writeConstructor(writer);
        }
    }

    @Override
    public void writeValidatorMethod(Append writer) {
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public boolean validate(%s value, ValidationRequest request, String field) {", this.shortName).eol();
        writer.append("    if (field != null) {").eol();
        writer.append("      request.pushPath(field);").eol();
        writer.append("    }").eol();
        for (FieldReader allField : this.allFields) {
            allField.writeValidate(writer);
        }
        writer.append("    if (field != null) {").eol();
        writer.append("      request.popPath();").eol();
        writer.append("    }").eol();
        writer.append("    return true;", this.shortName).eol();
        writer.append("  }").eol();
    }
}

