/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.ConstraintAdapterPrism;
import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.TopPackage;
import io.avaje.validation.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;

final class ComponentMetaData {
    private final List<String> allTypes = new ArrayList<String>();
    private final List<String> factoryTypes = new ArrayList<String>();
    private final List<TypeElement> annotationAdapters = new ArrayList<TypeElement>();
    private String fullName;

    ComponentMetaData() {
    }

    public String toString() {
        return this.allTypes.toString();
    }

    void initialiseFullName() {
        this.fullName();
    }

    boolean contains(String type) {
        return this.allTypes.contains(type);
    }

    void add(String type) {
        this.allTypes.add(type);
    }

    public void addAnnotationAdapter(TypeElement typeElement) {
        this.annotationAdapters.add(typeElement);
    }

    void addFactory(String fullName) {
        this.factoryTypes.add(fullName);
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    String fullName() {
        if (this.fullName == null) {
            ArrayList<String> types = new ArrayList<String>(this.allTypes);
            for (TypeElement adapter : this.annotationAdapters) {
                adapter.getQualifiedName().toString().transform(types::add);
            }
            Object topPackage = TopPackage.of(types);
            if (!((String)topPackage).endsWith(".valid")) {
                topPackage = (String)topPackage + ".valid";
            }
            this.fullName = (String)topPackage + ".GeneratedValidatorComponent";
        }
        return this.fullName;
    }

    String packageName() {
        return ProcessorUtils.packageOf(this.fullName());
    }

    List<String> all() {
        return this.allTypes;
    }

    List<String> allFactories() {
        return this.factoryTypes;
    }

    List<TypeElement> allAnnotationAdapters() {
        return this.annotationAdapters;
    }

    Collection<String> allImports() {
        TreeSet<String> packageImports = new TreeSet<String>();
        for (String adapterFullName : this.allTypes) {
            packageImports.add(ProcessorUtils.packageOf(adapterFullName) + ".*");
            packageImports.add(Util.baseTypeOfAdapter(adapterFullName));
        }
        for (TypeElement adapter : this.annotationAdapters) {
            String adapterFullName = adapter.getQualifiedName().toString();
            packageImports.add(ProcessorUtils.packageOf(adapterFullName) + ".*");
            packageImports.add(Util.baseTypeOfAdapter(adapterFullName));
            ConstraintAdapterPrism.getInstanceOn(adapter).value().toString().transform(packageImports::add);
        }
        return packageImports;
    }

    public boolean isEmpty() {
        return this.allTypes.isEmpty() && this.factoryTypes.isEmpty() && this.annotationAdapters.isEmpty();
    }
}

