/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AdapterHelper;
import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.ElementAnnotationContainer;
import io.avaje.validation.generator.MethodReader;
import io.avaje.validation.generator.PatternPrism;
import io.avaje.validation.generator.PrimitiveUtil;
import io.avaje.validation.generator.UType;
import io.avaje.validation.generator.Util;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

final class FieldReader {
    private final List<String> genericTypeParams;
    private final boolean publicField;
    private final UType genericType;
    private final String adapterFieldName;
    private final String adapterShortType;
    private final String fieldName;
    private MethodReader getter;
    private boolean genericTypeParameter;
    private final boolean optionalValidation;
    private final Element element;
    private final ElementAnnotationContainer elementAnnotations;
    private final boolean classLevel;
    private final boolean usePrimitiveValidation;

    FieldReader(Element element, List<String> genericTypeParams) {
        this(element, genericTypeParams, false);
    }

    FieldReader(Element element, List<String> genericTypeParams, boolean classLevel) {
        this.genericTypeParams = genericTypeParams;
        this.fieldName = element.getSimpleName().toString();
        this.publicField = element.getModifiers().contains((Object)Modifier.PUBLIC);
        this.element = element;
        this.elementAnnotations = ElementAnnotationContainer.create(element);
        this.genericType = this.elementAnnotations.genericType();
        String shortType = this.genericType.shortWithoutAnnotations();
        this.usePrimitiveValidation = PrimitiveUtil.isPrimitiveValidationType(shortType) && this.elementAnnotations.supportsPrimitiveValidation();
        this.adapterShortType = this.initAdapterShortType(shortType);
        this.adapterFieldName = this.initShortName();
        this.optionalValidation = Util.isNullable(element);
        this.classLevel = classLevel;
    }

    private String initAdapterShortType(String shortType) {
        if (this.usePrimitiveValidation) {
            return "ValidationAdapter.Primitive";
        }
        Object typeWrapped = "ValidationAdapter<" + PrimitiveUtil.wrap(shortType) + ">";
        for (String typeParam : this.genericTypeParams) {
            if (!((String)typeWrapped).contains("<" + typeParam + ">")) continue;
            this.genericTypeParameter = true;
            typeWrapped = ((String)typeWrapped).replace("<" + typeParam + ">", "<Object>");
        }
        return typeWrapped;
    }

    private String initShortName() {
        if (this.genericTypeParameter) {
            return Util.initLower(this.fieldName) + "ValidationAdapterGeneric";
        }
        return Util.initLower(this.fieldName) + "ValidationAdapter";
    }

    static String trimAnnotations(String type) {
        int pos = type.indexOf("@");
        if (pos == -1) {
            return type;
        }
        return type.substring(0, pos) + type.substring(type.lastIndexOf(32) + 1);
    }

    String fieldName() {
        return this.fieldName;
    }

    boolean typeObjectBooleanWithIsPrefix() {
        return this.nameHasIsPrefix() && "java.lang.Boolean".equals(this.genericType.mainType());
    }

    boolean typeBooleanWithIsPrefix() {
        return this.nameHasIsPrefix() && ("boolean".equals(this.genericType.mainType()) || "java.lang.Boolean".equals(this.genericType.mainType()));
    }

    private boolean nameHasIsPrefix() {
        return this.fieldName.length() > 2 && this.fieldName.startsWith("is") && Character.isUpperCase(this.fieldName.charAt(2));
    }

    void addImports(Set<String> importTypes) {
        if (PatternPrism.isPresent(this.element)) {
            importTypes.add("static io.avaje.validation.adapter.RegexFlag.*");
        }
        importTypes.addAll(this.genericType.importTypes());
        this.elementAnnotations.addImports(importTypes);
    }

    void cascadeTypes(Set<String> types) {
        String mainType = this.genericType.mainType();
        if ("java.util.List".equals(mainType) || "java.util.Set".equals(mainType)) {
            types.add(this.genericType.param0().fullWithoutAnnotations());
        } else if ("java.util.Map".equals(mainType)) {
            types.add(this.genericType.param1().fullWithoutAnnotations());
        } else {
            types.add(mainType);
        }
    }

    void getterMethod(MethodReader getter) {
        if (getter != null) {
            this.getter = getter;
        }
    }

    boolean isPublicField() {
        return this.publicField;
    }

    String adapterShortType() {
        return this.genericType.shortWithoutAnnotations();
    }

    void writeField(Append writer) {
        writer.append("  private final %s %s;", this.adapterShortType, this.adapterFieldName).eol();
    }

    private void writeGetValue(Append writer, String suffix) {
        if (!this.classLevel) {
            if (this.getter != null) {
                writer.append("value.%s()%s", this.getter.getName(), suffix);
            } else if (this.publicField) {
                writer.append("value.%s%s", this.fieldName, suffix);
            } else {
                APContext.logError(this.element, "Field" + this.fieldName + " is inaccessible. Add a getter or make the field public.", new Object[0]);
            }
        }
    }

    void writeValidate(Append writer) {
        if (this.classLevel) {
            writer.append("    if (!request.hasViolations()) {\n      %s.validate(value, request, field);\n    }\n", this.adapterFieldName);
            writer.eol().eol();
            return;
        }
        writer.append("    var _$%s = ", this.fieldName);
        this.writeGetValue(writer, ";");
        writer.eol();
        if (this.optionalValidation) {
            writer.append("    if(_$%s != null) {", this.fieldName);
        }
        writer.append("    %s.validate(_$%s", this.adapterFieldName, this.fieldName);
        writer.append(", request, \"%s\");", this.fieldName);
        if (this.optionalValidation) {
            writer.append("    }");
        }
        writer.eol().eol();
    }

    public String toString() {
        return this.fieldName;
    }

    public UType type() {
        return this.genericType;
    }

    public void writeConstructor(Append writer) {
        writer.append("    this.%s = ", this.adapterFieldName).eol();
        new AdapterHelper(writer, this.elementAnnotations, "        ", PrimitiveUtil.wrap(this.genericType.shortWithoutAnnotations()), this.genericType, this.classLevel).usePrimitiveValidation(this.usePrimitiveValidation).write();
        writer.append(";").eol().eol();
    }

    public boolean isClassLvl() {
        return this.classLevel;
    }

    public boolean hasConstraints() {
        return !this.elementAnnotations.isEmpty();
    }
}

